/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.storage.ChunkSystemChunkBuffer;
import ca.spottedleaf.moonrise.patches.chunk_system.storage.ChunkSystemRegionFile;
import ca.spottedleaf.moonrise.patches.chunk_system.util.stream.ExternalChunkStreamMarker;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionFileVersion;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RegionFile.class})
abstract class RegionFileMixin
implements ChunkSystemRegionFile {
    @Shadow
    @Final
    RegionFileVersion version;

    RegionFileMixin() {
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController.WriteData moonrise$startWrite(CompoundTag data, ChunkPos pos) throws IOException {
        RegionFile regionFile = (RegionFile)this;
        Objects.requireNonNull(regionFile);
        RegionFile.ChunkBuffer buffer = new RegionFile.ChunkBuffer(regionFile, pos);
        ((ChunkSystemChunkBuffer)buffer).moonrise$setWriteOnClose(false);
        DataOutputStream out = new DataOutputStream(this.version.wrap((OutputStream)buffer));
        return new MoonriseRegionFileIO.RegionDataController.WriteData(data, MoonriseRegionFileIO.RegionDataController.WriteData.WriteResult.WRITE, out, ((ChunkSystemChunkBuffer)buffer)::moonrise$write);
    }

    @Inject(method={"createExternalChunkInputStream"}, cancellable=true, at={@At(value="RETURN")})
    private void markExternalChunkStreams(CallbackInfoReturnable<DataInputStream> cir) {
        DataInputStream is = (DataInputStream)cir.getReturnValue();
        if (is == null) {
            return;
        }
        cir.setReturnValue((Object)new ExternalChunkStreamMarker(is));
    }
}

