/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.patches.chunk_system.io.ChunkSystemRegionFileStorage;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.storage.ChunkSystemRegionFile;
import ca.spottedleaf.moonrise.patches.chunk_system.util.stream.ExternalChunkStreamMarker;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.FileUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.util.ExceptionCollector;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={RegionFileStorage.class})
abstract class RegionFileStorageMixin
implements ChunkSystemRegionFileStorage,
AutoCloseable {
    @Shadow
    @Final
    private Long2ObjectLinkedOpenHashMap<RegionFile> regionCache;
    @Shadow
    @Final
    private static int MAX_CACHE_SIZE;
    @Shadow
    @Final
    private Path folder;
    @Shadow
    @Final
    private boolean sync;
    @Shadow
    @Final
    private RegionStorageInfo info;
    @Unique
    private static final int REGION_SHIFT = 5;
    @Unique
    private static final int MAX_NON_EXISTING_CACHE = 4096;
    @Unique
    private final LongLinkedOpenHashSet nonExistingRegionFiles = new LongLinkedOpenHashSet();

    RegionFileStorageMixin() {
    }

    @Unique
    private static String getRegionFileName(int chunkX, int chunkZ) {
        return "r." + (chunkX >> 5) + "." + (chunkZ >> 5) + ".mca";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private boolean doesRegionFilePossiblyExist(long position) {
        LongLinkedOpenHashSet longLinkedOpenHashSet = this.nonExistingRegionFiles;
        synchronized (longLinkedOpenHashSet) {
            if (this.nonExistingRegionFiles.contains(position)) {
                this.nonExistingRegionFiles.addAndMoveToFirst(position);
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private void createRegionFile(long position) {
        LongLinkedOpenHashSet longLinkedOpenHashSet = this.nonExistingRegionFiles;
        synchronized (longLinkedOpenHashSet) {
            this.nonExistingRegionFiles.remove(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private void markNonExisting(long position) {
        LongLinkedOpenHashSet longLinkedOpenHashSet = this.nonExistingRegionFiles;
        synchronized (longLinkedOpenHashSet) {
            if (this.nonExistingRegionFiles.addAndMoveToFirst(position)) {
                while (this.nonExistingRegionFiles.size() >= 4096) {
                    this.nonExistingRegionFiles.removeLastLong();
                }
            }
        }
    }

    @Override
    public final boolean moonrise$doesRegionFileNotExistNoIO(int chunkX, int chunkZ) {
        return !this.doesRegionFilePossiblyExist(ChunkPos.asLong((int)(chunkX >> 5), (int)(chunkZ >> 5)));
    }

    @Override
    public final synchronized RegionFile moonrise$getRegionFileIfLoaded(int chunkX, int chunkZ) {
        return (RegionFile)this.regionCache.getAndMoveToFirst(ChunkPos.asLong((int)(chunkX >> 5), (int)(chunkZ >> 5)));
    }

    @Override
    public final synchronized RegionFile moonrise$getRegionFileIfExists(int chunkX, int chunkZ) throws IOException {
        Path regionPath;
        long key = ChunkPos.asLong((int)(chunkX >> 5), (int)(chunkZ >> 5));
        RegionFile ret = (RegionFile)this.regionCache.getAndMoveToFirst(key);
        if (ret != null) {
            return ret;
        }
        if (!this.doesRegionFilePossiblyExist(key)) {
            return null;
        }
        if (this.regionCache.size() >= MAX_CACHE_SIZE) {
            ((RegionFile)this.regionCache.removeLast()).close();
        }
        if (!Files.exists(regionPath = this.folder.resolve(RegionFileStorageMixin.getRegionFileName(chunkX, chunkZ)), new LinkOption[0])) {
            this.markNonExisting(key);
            return null;
        }
        this.createRegionFile(key);
        FileUtil.createDirectoriesSafe((Path)this.folder);
        ret = new RegionFile(this.info, regionPath, this.folder, this.sync);
        this.regionCache.putAndMoveToFirst(key, (Object)ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public final RegionFile getRegionFile(ChunkPos chunkPos) throws IOException {
        RegionFileStorageMixin regionFileStorageMixin = this;
        synchronized (regionFileStorageMixin) {
            long key = ChunkPos.asLong((int)(chunkPos.x >> 5), (int)(chunkPos.z >> 5));
            RegionFile ret = (RegionFile)this.regionCache.getAndMoveToFirst(key);
            if (ret != null) {
                return ret;
            }
            if (this.regionCache.size() >= MAX_CACHE_SIZE) {
                ((RegionFile)this.regionCache.removeLast()).close();
            }
            Path regionPath = this.folder.resolve(RegionFileStorageMixin.getRegionFileName(chunkPos.x, chunkPos.z));
            this.createRegionFile(key);
            FileUtil.createDirectoriesSafe((Path)this.folder);
            ret = new RegionFile(this.info, regionPath, this.folder, this.sync);
            this.regionCache.putAndMoveToFirst(key, (Object)ret);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final MoonriseRegionFileIO.RegionDataController.WriteData moonrise$startWrite(int chunkX, int chunkZ, CompoundTag compound) throws IOException {
        if (compound == null) {
            return new MoonriseRegionFileIO.RegionDataController.WriteData(compound, MoonriseRegionFileIO.RegionDataController.WriteData.WriteResult.DELETE, null, null);
        }
        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
        RegionFile regionFile = this.getRegionFile(pos);
        MoonriseRegionFileIO.RegionDataController.WriteData writeData = ((ChunkSystemRegionFile)regionFile).moonrise$startWrite(compound, pos);
        try {
            NbtIo.write((CompoundTag)compound, (DataOutput)writeData.output());
        }
        finally {
            writeData.output().close();
        }
        return writeData;
    }

    @Override
    public final void moonrise$finishWrite(int chunkX, int chunkZ, MoonriseRegionFileIO.RegionDataController.WriteData writeData) throws IOException {
        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
        if (writeData.result() == MoonriseRegionFileIO.RegionDataController.WriteData.WriteResult.DELETE) {
            RegionFile regionFile = this.moonrise$getRegionFileIfExists(chunkX, chunkZ);
            if (regionFile != null) {
                regionFile.clear(pos);
            }
            return;
        }
        writeData.write().run(this.getRegionFile(pos));
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController.ReadData moonrise$readData(int chunkX, int chunkZ) throws IOException {
        DataInputStream input;
        RegionFile regionFile = this.moonrise$getRegionFileIfExists(chunkX, chunkZ);
        DataInputStream dataInputStream = input = regionFile == null ? null : regionFile.getChunkDataInputStream(new ChunkPos(chunkX, chunkZ));
        if (input == null) {
            return new MoonriseRegionFileIO.RegionDataController.ReadData(MoonriseRegionFileIO.RegionDataController.ReadData.ReadResult.NO_DATA, null, null);
        }
        MoonriseRegionFileIO.RegionDataController.ReadData ret = new MoonriseRegionFileIO.RegionDataController.ReadData(MoonriseRegionFileIO.RegionDataController.ReadData.ReadResult.HAS_DATA, input, null);
        if (!(input instanceof ExternalChunkStreamMarker)) {
            return ret;
        }
        CompoundTag syncRead = this.moonrise$finishRead(chunkX, chunkZ, ret);
        if (syncRead == null) {
            return this.moonrise$readData(chunkX, chunkZ);
        }
        return new MoonriseRegionFileIO.RegionDataController.ReadData(MoonriseRegionFileIO.RegionDataController.ReadData.ReadResult.SYNC_READ, null, syncRead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CompoundTag moonrise$finishRead(int chunkX, int chunkZ, MoonriseRegionFileIO.RegionDataController.ReadData readData) throws IOException {
        try {
            CompoundTag compoundTag = NbtIo.read((DataInput)readData.input());
            return compoundTag;
        }
        finally {
            readData.input().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Overwrite
    public void close() throws IOException {
        RegionFileStorageMixin regionFileStorageMixin = this;
        synchronized (regionFileStorageMixin) {
            ExceptionCollector exceptionCollector = new ExceptionCollector();
            for (RegionFile regionFile : this.regionCache.values()) {
                try {
                    regionFile.close();
                }
                catch (IOException ex) {
                    exceptionCollector.add((Throwable)ex);
                }
            }
            exceptionCollector.throwIfPresent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public void flush() throws IOException {
        RegionFileStorageMixin regionFileStorageMixin = this;
        synchronized (regionFileStorageMixin) {
            ExceptionCollector exceptionCollector = new ExceptionCollector();
            for (RegionFile regionFile : this.regionCache.values()) {
                try {
                    regionFile.flush();
                }
                catch (IOException ex) {
                    exceptionCollector.add((Throwable)ex);
                }
            }
            exceptionCollector.throwIfPresent();
        }
    }

    @Redirect(method={"read"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/storage/RegionFileStorage;getRegionFile(Lnet/minecraft/world/level/ChunkPos;)Lnet/minecraft/world/level/chunk/storage/RegionFile;"))
    private RegionFile avoidCreatingReadRegionFile(RegionFileStorage instance, ChunkPos chunkPos) throws IOException {
        return ((RegionFileStorageMixin)instance).moonrise$getRegionFileIfExists(chunkPos.x, chunkPos.z);
    }

    @Inject(method={"read"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/storage/RegionFile;getChunkDataInputStream(Lnet/minecraft/world/level/ChunkPos;)Ljava/io/DataInputStream;")})
    private void avoidCreatingReadRegionFileExit(ChunkPos chunkPos, CallbackInfoReturnable<CompoundTag> cir, RegionFile regionFile) {
        if (regionFile == null) {
            cir.setReturnValue(null);
            return;
        }
    }

    @Redirect(method={"scanChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/storage/RegionFileStorage;getRegionFile(Lnet/minecraft/world/level/ChunkPos;)Lnet/minecraft/world/level/chunk/storage/RegionFile;"))
    private RegionFile avoidCreatingScanRegionFile(RegionFileStorage instance, ChunkPos chunkPos) throws IOException {
        return ((RegionFileStorageMixin)instance).moonrise$getRegionFileIfExists(chunkPos.x, chunkPos.z);
    }

    @Inject(method={"scanChunk"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/storage/RegionFile;getChunkDataInputStream(Lnet/minecraft/world/level/ChunkPos;)Ljava/io/DataInputStream;")})
    private void avoidCreatingScanRegionFileExit(ChunkPos chunkPos, StreamTagVisitor streamTagVisitor, CallbackInfo ci, RegionFile regionFile) {
        if (regionFile == null) {
            ci.cancel();
            return;
        }
    }

    @Inject(method={"write"}, cancellable=true, at={@At(value="HEAD")})
    private void avoidCreatingWriteRegionFile(ChunkPos chunkPos, CompoundTag compoundTag, CallbackInfo ci) throws IOException {
        if (compoundTag == null && this.moonrise$getRegionFileIfExists(chunkPos.x, chunkPos.z) == null) {
            ci.cancel();
            return;
        }
    }
}

