/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.common.map.SynchronisedLong2BooleanMap;
import ca.spottedleaf.moonrise.common.map.SynchronisedLong2ObjectMap;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StructureCheck.class})
abstract class StructureCheckMixin {
    @Shadow
    private Long2ObjectMap<Object2IntMap<Structure>> loadedChunks;
    @Shadow
    private Map<Structure, Long2BooleanMap> featureChecks;
    @Unique
    private static final int CHUNK_TOTAL_LIMIT = 2020050;
    @Unique
    private static final int PER_FEATURE_CHECK_LIMIT = 2020050;
    @Unique
    private final SynchronisedLong2ObjectMap<Object2IntMap<Structure>> loadedChunksSafe = new SynchronisedLong2ObjectMap(2020050);
    @Unique
    private final ConcurrentHashMap<Structure, SynchronisedLong2BooleanMap> featureChecksSafe = new ConcurrentHashMap();

    StructureCheckMixin() {
    }

    @Shadow
    protected abstract boolean canCreateStructure(ChunkPos var1, Structure var2);

    @Shadow
    private static Object2IntMap<Structure> deduplicateEmptyMap(Object2IntMap<Structure> object2IntMap) {
        return null;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initHook(ChunkScanAccess chunkScanAccess, RegistryAccess registryAccess, StructureTemplateManager structureTemplateManager, ResourceKey resourceKey, ChunkGenerator chunkGenerator, RandomState randomState, LevelHeightAccessor levelHeightAccessor, BiomeSource biomeSource, long l, DataFixer dataFixer, CallbackInfo ci) {
        this.loadedChunks = null;
        this.featureChecks = null;
    }

    @Redirect(method={"checkStart"}, at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;get(J)Ljava/lang/Object;", remap=false))
    private <V> V redirectCachedGet(Long2ObjectMap<V> instance, long pos) {
        return (V)this.loadedChunksSafe.get(pos);
    }

    @Inject(method={"checkStart"}, cancellable=true, at={@At(value="INVOKE", target="Ljava/util/Map;computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;")})
    private void redirectUncached(ChunkPos pos, Structure structure, StructurePlacement structurePlacement, boolean bl, CallbackInfoReturnable<StructureCheckResult> cir) {
        boolean ret = this.featureChecksSafe.computeIfAbsent(structure, structure2 -> new SynchronisedLong2BooleanMap(2020050)).getOrCompute(pos.toLong(), chunkPos -> this.canCreateStructure(pos, structure));
        cir.setReturnValue((Object)(!ret ? StructureCheckResult.START_NOT_PRESENT : StructureCheckResult.CHUNK_LOAD_NEEDED));
    }

    @Overwrite
    public void storeFullResults(long pos, Object2IntMap<Structure> referencesByStructure) {
        this.loadedChunksSafe.put(pos, StructureCheckMixin.deduplicateEmptyMap(referencesByStructure));
        for (SynchronisedLong2BooleanMap value : this.featureChecksSafe.values()) {
            value.remove(pos);
        }
    }

    @Overwrite
    public void incrementReference(ChunkPos pos, Structure structure) {
        this.loadedChunksSafe.compute(pos.toLong(), (posx, referencesByStructure) -> {
            if (referencesByStructure == null) {
                referencesByStructure = new Object2IntOpenHashMap();
            } else {
                Object2IntOpenHashMap object2IntOpenHashMap;
                if (referencesByStructure instanceof Object2IntOpenHashMap) {
                    Object2IntOpenHashMap fastClone = (Object2IntOpenHashMap)referencesByStructure;
                    object2IntOpenHashMap = fastClone.clone();
                } else {
                    object2IntOpenHashMap = new Object2IntOpenHashMap(referencesByStructure);
                }
                referencesByStructure = object2IntOpenHashMap;
            }
            referencesByStructure.computeInt((Object)structure, (feature, references) -> references == null ? 1 : references + 1);
            return referencesByStructure;
        });
    }
}

