/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.collisions;

import ca.spottedleaf.moonrise.common.util.FlatBitsetUtil;
import ca.spottedleaf.moonrise.common.util.MixinWorkarounds;
import ca.spottedleaf.moonrise.patches.collisions.shape.CachedShapeData;
import ca.spottedleaf.moonrise.patches.collisions.shape.CollisionDiscreteVoxelShape;
import java.util.ArrayList;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BitSetDiscreteVoxelShape.class})
abstract class BitSetDiscreteVoxelShapeMixin
extends DiscreteVoxelShape {
    @Unique
    private static final boolean DEBUG_ALL_BOXES = false;

    protected BitSetDiscreteVoxelShapeMixin(int i, int j, int k) {
        super(i, j, k);
    }

    @Unique
    private static void forAllBoxesVanilla(DiscreteVoxelShape discreteVoxelShape, DiscreteVoxelShape.IntLineConsumer intLineConsumer, boolean bl) {
        BitSetDiscreteVoxelShape bitSetDiscreteVoxelShape = new BitSetDiscreteVoxelShape(discreteVoxelShape);
        for (int i = 0; i < bitSetDiscreteVoxelShape.getYSize(); ++i) {
            for (int j = 0; j < bitSetDiscreteVoxelShape.getXSize(); ++j) {
                int k = -1;
                for (int l = 0; l <= bitSetDiscreteVoxelShape.getZSize(); ++l) {
                    if (bitSetDiscreteVoxelShape.isFullWide(j, i, l)) {
                        if (bl) {
                            if (k != -1) continue;
                            k = l;
                            continue;
                        }
                        intLineConsumer.consume(j, i, l, j + 1, i + 1, l + 1);
                        continue;
                    }
                    if (k == -1) continue;
                    int m = j;
                    int n = i;
                    bitSetDiscreteVoxelShape.clearZStrip(k, l, j, i);
                    while (bitSetDiscreteVoxelShape.isZStripFull(k, l, m + 1, i)) {
                        bitSetDiscreteVoxelShape.clearZStrip(k, l, m + 1, i);
                        ++m;
                    }
                    while (bitSetDiscreteVoxelShape.isXZRectangleFull(j, m + 1, k, l, n + 1)) {
                        for (int o = j; o <= m; ++o) {
                            bitSetDiscreteVoxelShape.clearZStrip(k, l, o, n + 1);
                        }
                        ++n;
                    }
                    intLineConsumer.consume(j, i, k, m + 1, n + 1, l);
                    k = -1;
                }
            }
        }
    }

    @Unique
    private static void chkForAll(DiscreteVoxelShape shape, boolean mergeAdjacent) {
        record Range(int sx, int sy, int sz, int ex, int ey, int ez) {
        }
        if (new Throwable().getStackTrace()[2].getMethodName().contains("chkForAll")) {
            return;
        }
        ArrayList vanillaRanges = new ArrayList();
        ArrayList moonriseRanges = new ArrayList();
        BitSetDiscreteVoxelShapeMixin.forAllBoxesVanilla(shape, (x1, y1, z1, x2, y2, z2) -> vanillaRanges.add(new Range(x1, y1, z1, x2, y2, z2)), mergeAdjacent);
        BitSetDiscreteVoxelShapeMixin.forAllBoxes(shape, (x1, y1, z1, x2, y2, z2) -> moonriseRanges.add(new Range(x1, y1, z1, x2, y2, z2)), mergeAdjacent);
        if (!vanillaRanges.equals(moonriseRanges)) {
            BitSetDiscreteVoxelShapeMixin.forAllBoxesVanilla(shape, (x1, y1, z1, x2, y2, z2) -> {}, mergeAdjacent);
            BitSetDiscreteVoxelShapeMixin.forAllBoxes(shape, (x1, y1, z1, x2, y2, z2) -> {}, mergeAdjacent);
            throw new IllegalStateException();
        }
    }

    @Overwrite
    public static void forAllBoxes(DiscreteVoxelShape shape, DiscreteVoxelShape.IntLineConsumer consumer, boolean mergeAdjacent) {
        CachedShapeData cache = ((CollisionDiscreteVoxelShape)shape).moonrise$getOrCreateCachedShapeData();
        int sizeX = cache.sizeX();
        int sizeY = cache.sizeY();
        int sizeZ = cache.sizeZ();
        int indexY = 0;
        int incY = sizeZ;
        int incX = sizeZ * sizeY;
        long[] bitset = cache.voxelSet();
        if (!mergeAdjacent) {
            int y = 0;
            while (y < sizeY) {
                int indexX = indexY;
                int x = 0;
                while (x < sizeX) {
                    int indexZ = indexX;
                    int z = 0;
                    while (z < sizeZ) {
                        if ((bitset[indexZ >>> 6] & 1L << indexZ) != 0L) {
                            consumer.consume(x, y, z, x + 1, y + 1, z + 1);
                        }
                        ++z;
                        ++indexZ;
                    }
                    ++x;
                    indexX += incX;
                }
                ++y;
                indexY += incY;
            }
        } else {
            bitset = MixinWorkarounds.clone(bitset);
            int y = 0;
            while (y < sizeY) {
                int indexX = indexY;
                int x = 0;
                while (x < sizeX) {
                    int firstSetZ;
                    int zIdx = indexX;
                    int endIndex = indexX + sizeZ;
                    while (zIdx < endIndex && (firstSetZ = FlatBitsetUtil.firstSet(bitset, zIdx, endIndex)) != -1) {
                        int lastSetZ = FlatBitsetUtil.firstClear(bitset, firstSetZ, endIndex);
                        if (lastSetZ == -1) {
                            lastSetZ = endIndex;
                        }
                        FlatBitsetUtil.clearRange(bitset, firstSetZ, lastSetZ);
                        int endX = x + 1;
                        int neighbourIdxStart = firstSetZ + incX;
                        int neighbourIdxEnd = lastSetZ + incX;
                        while (endX < sizeX && FlatBitsetUtil.isRangeSet(bitset, neighbourIdxStart, neighbourIdxEnd)) {
                            ++endX;
                            FlatBitsetUtil.clearRange(bitset, neighbourIdxStart, neighbourIdxEnd);
                            neighbourIdxStart += incX;
                            neighbourIdxEnd += incX;
                        }
                        int endY = y + 1;
                        int firstSetZY = firstSetZ + incY;
                        int lastSetZY = lastSetZ + incY;
                        block7: while (endY < sizeY) {
                            int testX = x;
                            int start = firstSetZY;
                            int end = lastSetZY;
                            while (testX < endX) {
                                if (!FlatBitsetUtil.isRangeSet(bitset, start, end)) break block7;
                                ++testX;
                                start += incX;
                                end += incX;
                            }
                            ++endY;
                            testX = x;
                            start = firstSetZY;
                            end = lastSetZY;
                            while (testX < endX) {
                                FlatBitsetUtil.clearRange(bitset, start, end);
                                ++testX;
                                start += incX;
                                end += incX;
                            }
                            firstSetZY += incY;
                            lastSetZY += incY;
                        }
                        consumer.consume(x, y, firstSetZ - indexX, endX, endY, lastSetZ - indexX);
                        zIdx = lastSetZ;
                    }
                    ++x;
                    indexX += incX;
                }
                ++y;
                indexY += incY;
            }
        }
    }
}

