/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.collisions;

import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.block_counting.BlockCountingChunkSection;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import ca.spottedleaf.moonrise.patches.collisions.block.CollisionBlockState;
import ca.spottedleaf.moonrise.patches.collisions.shape.CollisionVoxelShape;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Level.class})
abstract class LevelMixin
implements LevelAccessor,
AutoCloseable {
    @Unique
    private static final FluidState AIR_FLUIDSTATE = Fluids.EMPTY.defaultFluidState();

    LevelMixin() {
    }

    @Shadow
    public abstract LevelChunk getChunk(int var1, int var2);

    public boolean isUnobstructed(Entity entity) {
        AABB boundingBox = entity.getBoundingBox();
        if (CollisionUtil.isEmpty(boundingBox)) {
            return true;
        }
        List entities = this.getEntities(entity, boundingBox.inflate(-1.0E-7, -1.0E-7, -1.0E-7), null);
        int len = entities.size();
        for (int i = 0; i < len; ++i) {
            Entity otherEntity = (Entity)entities.get(i);
            if (otherEntity.isSpectator() || otherEntity.isRemoved() || !otherEntity.blocksBuilding || otherEntity.isPassengerOfSameVehicle(entity)) continue;
            return false;
        }
        return true;
    }

    @Unique
    private static BlockHitResult miss(ClipContext clipContext) {
        Vec3 to = clipContext.getTo();
        Vec3 from = clipContext.getFrom();
        return BlockHitResult.miss((Vec3)to, (Direction)Direction.getApproximateNearest((double)(from.x - to.x), (double)(from.y - to.y), (double)(from.z - to.z)), (BlockPos)BlockPos.containing((double)to.x, (double)to.y, (double)to.z));
    }

    @Unique
    private static BlockHitResult fastClip(Vec3 from, Vec3 to, Level level, ClipContext clipContext) {
        double adjX = 1.0E-7 * (from.x - to.x);
        double adjY = 1.0E-7 * (from.y - to.y);
        double adjZ = 1.0E-7 * (from.z - to.z);
        if (adjX == 0.0 && adjY == 0.0 && adjZ == 0.0) {
            return LevelMixin.miss(clipContext);
        }
        double toXAdj = to.x - adjX;
        double toYAdj = to.y - adjY;
        double toZAdj = to.z - adjZ;
        double fromXAdj = from.x + adjX;
        double fromYAdj = from.y + adjY;
        double fromZAdj = from.z + adjZ;
        int currX = Mth.floor((double)fromXAdj);
        int currY = Mth.floor((double)fromYAdj);
        int currZ = Mth.floor((double)fromZAdj);
        BlockPos.MutableBlockPos currPos = new BlockPos.MutableBlockPos();
        double diffX = toXAdj - fromXAdj;
        double diffY = toYAdj - fromYAdj;
        double diffZ = toZAdj - fromZAdj;
        double dxDouble = Math.signum(diffX);
        double dyDouble = Math.signum(diffY);
        double dzDouble = Math.signum(diffZ);
        int dx = (int)dxDouble;
        int dy = (int)dyDouble;
        int dz = (int)dzDouble;
        double normalizedDiffX = diffX == 0.0 ? Double.MAX_VALUE : dxDouble / diffX;
        double normalizedDiffY = diffY == 0.0 ? Double.MAX_VALUE : dyDouble / diffY;
        double normalizedDiffZ = diffZ == 0.0 ? Double.MAX_VALUE : dzDouble / diffZ;
        double normalizedCurrX = normalizedDiffX * (diffX > 0.0 ? 1.0 - Mth.frac((double)fromXAdj) : Mth.frac((double)fromXAdj));
        double normalizedCurrY = normalizedDiffY * (diffY > 0.0 ? 1.0 - Mth.frac((double)fromYAdj) : Mth.frac((double)fromYAdj));
        double normalizedCurrZ = normalizedDiffZ * (diffZ > 0.0 ? 1.0 - Mth.frac((double)fromZAdj) : Mth.frac((double)fromZAdj));
        LevelChunkSection[] lastChunk = null;
        PalettedContainer lastSection = null;
        int lastChunkX = Integer.MIN_VALUE;
        int lastChunkY = Integer.MIN_VALUE;
        int lastChunkZ = Integer.MIN_VALUE;
        int minSection = WorldUtil.getMinSection(level);
        while (true) {
            BlockState blockState;
            currPos.set(currX, currY, currZ);
            int newChunkX = currX >> 4;
            int newChunkY = currY >> 4;
            int newChunkZ = currZ >> 4;
            int chunkDiff = newChunkX ^ lastChunkX | newChunkZ ^ lastChunkZ;
            int chunkYDiff = newChunkY ^ lastChunkY;
            if ((chunkDiff | chunkYDiff) != 0) {
                int sectionY;
                if (chunkDiff != 0) {
                    lastChunk = level.getChunk(newChunkX, newChunkZ).getSections();
                }
                lastSection = (sectionY = newChunkY - minSection) >= 0 && sectionY < lastChunk.length ? lastChunk[sectionY].states : null;
                lastChunkX = newChunkX;
                lastChunkY = newChunkY;
                lastChunkZ = newChunkZ;
            }
            if (lastSection != null && !(blockState = (BlockState)lastSection.get(currX & 0xF | (currZ & 0xF) << 4 | (currY & 0xF) << 8)).isAir()) {
                VoxelShape fluidCollision;
                BlockHitResult fluidHit;
                FluidState fluidState;
                BlockHitResult blockHit;
                VoxelShape blockCollision = clipContext.getBlockShape(blockState, (BlockGetter)level, (BlockPos)currPos);
                BlockHitResult blockHitResult = blockHit = blockCollision.isEmpty() ? null : level.clipWithInteractionOverride(from, to, (BlockPos)currPos, blockCollision, blockState);
                if (clipContext.fluid != ClipContext.Fluid.NONE && (fluidState = blockState.getFluidState()) != AIR_FLUIDSTATE && (fluidHit = (fluidCollision = clipContext.getFluidShape(fluidState, (BlockGetter)level, (BlockPos)currPos)).clip(from, to, (BlockPos)currPos)) != null) {
                    if (blockHit == null) {
                        return fluidHit;
                    }
                    return from.distanceToSqr(blockHit.getLocation()) <= from.distanceToSqr(fluidHit.getLocation()) ? blockHit : fluidHit;
                }
                if (blockHit != null) {
                    return blockHit;
                }
            }
            if (normalizedCurrX > 1.0 && normalizedCurrY > 1.0 && normalizedCurrZ > 1.0) {
                return LevelMixin.miss(clipContext);
            }
            if (normalizedCurrX < normalizedCurrY) {
                if (normalizedCurrX < normalizedCurrZ) {
                    currX += dx;
                    normalizedCurrX += normalizedDiffX;
                    continue;
                }
                currZ += dz;
                normalizedCurrZ += normalizedDiffZ;
                continue;
            }
            if (normalizedCurrY < normalizedCurrZ) {
                currY += dy;
                normalizedCurrY += normalizedDiffY;
                continue;
            }
            currZ += dz;
            normalizedCurrZ += normalizedDiffZ;
        }
    }

    public BlockHitResult clip(ClipContext clipContext) {
        return LevelMixin.fastClip(clipContext.getFrom(), clipContext.getTo(), (Level)this, clipContext);
    }

    public boolean noCollision(Entity entity, AABB box) {
        int flags;
        int n = flags = entity == null ? 12 : 8;
        if (CollisionUtil.getCollisionsForBlocksOrWorldBorder((Level)this, entity, box, null, null, flags, null)) {
            return false;
        }
        return !CollisionUtil.getEntityHardCollisions((Level)this, entity, box, null, flags, null);
    }

    public boolean collidesWithSuffocatingBlock(Entity entity, AABB box) {
        return CollisionUtil.getCollisionsForBlocksOrWorldBorder((Level)this, entity, box, null, null, 8, (state, pos) -> state.isSuffocating((BlockGetter)((Level)this), pos));
    }

    @Unique
    private static VoxelShape inflateAABBToVoxel(AABB aabb, double x, double y, double z) {
        return Shapes.create((double)(aabb.minX - x), (double)(aabb.minY - y), (double)(aabb.minZ - z), (double)(aabb.maxX + x), (double)(aabb.maxY + y), (double)(aabb.maxZ + z));
    }

    public Optional<Vec3> findFreePosition(Entity entity, VoxelShape boundsShape, Vec3 fromPosition, double rangeX, double rangeY, double rangeZ) {
        if (boundsShape.isEmpty()) {
            return Optional.empty();
        }
        double expandByX = rangeX * 0.5;
        double expandByY = rangeY * 0.5;
        double expandByZ = rangeZ * 0.5;
        AABB collectionVolume = boundsShape.bounds().inflate(expandByX, expandByY, expandByZ);
        ArrayList<AABB> aabbs = new ArrayList<AABB>();
        ArrayList<VoxelShape> voxels = new ArrayList<VoxelShape>();
        CollisionUtil.getCollisionsForBlocksOrWorldBorder((Level)this, entity, collectionVolume, voxels, aabbs, 4, null);
        WorldBorder worldBorder = this.getWorldBorder();
        if (worldBorder != null) {
            aabbs.removeIf(aabb -> !worldBorder.isWithinBounds(aabb));
            voxels.removeIf(shape -> !worldBorder.isWithinBounds(shape.bounds()));
        }
        int len = voxels.size();
        for (int i = 0; i < len; ++i) {
            aabbs.addAll(((VoxelShape)voxels.get(i)).toAabbs());
        }
        VoxelShape first = aabbs.isEmpty() ? Shapes.empty() : LevelMixin.inflateAABBToVoxel((AABB)aabbs.get(0), expandByX, expandByY, expandByZ);
        VoxelShape[] rest = new VoxelShape[Math.max(0, aabbs.size() - 1)];
        int len2 = aabbs.size();
        for (int i = 1; i < len2; ++i) {
            rest[i - 1] = LevelMixin.inflateAABBToVoxel((AABB)aabbs.get(i), expandByX, expandByY, expandByZ);
        }
        VoxelShape joined = Shapes.or((VoxelShape)first, (VoxelShape[])rest);
        VoxelShape freeSpace = Shapes.joinUnoptimized((VoxelShape)boundsShape, (VoxelShape)joined, (BooleanOp)BooleanOp.ONLY_FIRST);
        return freeSpace.closestPointTo(fromPosition);
    }

    public Optional<BlockPos> findSupportingBlock(Entity entity, AABB aabb) {
        int minSection = WorldUtil.getMinSection((Level)this);
        int minBlockX = Mth.floor((double)(aabb.minX - 1.0E-7)) - 1;
        int maxBlockX = Mth.floor((double)(aabb.maxX + 1.0E-7)) + 1;
        int minBlockY = Math.max((minSection << 4) - 1, Mth.floor((double)(aabb.minY - 1.0E-7)) - 1);
        int maxBlockY = Math.min((WorldUtil.getMaxSection((Level)this) << 4) + 16, Mth.floor((double)(aabb.maxY + 1.0E-7)) + 1);
        int minBlockZ = Mth.floor((double)(aabb.minZ - 1.0E-7)) - 1;
        int maxBlockZ = Mth.floor((double)(aabb.maxZ + 1.0E-7)) + 1;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        CollisionUtil.LazyEntityCollisionContext collisionShape = new CollisionUtil.LazyEntityCollisionContext(entity);
        BlockPos selected = null;
        double selectedDistance = Double.MAX_VALUE;
        Vec3 entityPos = entity.position();
        if (minBlockY > maxBlockY) {
            return Optional.empty();
        }
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int maxChunkY = maxBlockY >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        ChunkSource chunkSource = this.getChunkSource();
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                ChunkAccess chunk = chunkSource.getChunk(currChunkX, currChunkZ, ChunkStatus.FULL, false);
                if (chunk == null) continue;
                LevelChunkSection[] sections = chunk.getSections();
                for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                    LevelChunkSection section;
                    int sectionIdx = currChunkY - minSection;
                    if (sectionIdx < 0 || sectionIdx >= sections.length || (section = sections[sectionIdx]).hasOnlyAir()) continue;
                    boolean hasSpecial = ((BlockCountingChunkSection)section).moonrise$hasSpecialCollidingBlocks();
                    int sectionAdjust = !hasSpecial ? 1 : 0;
                    PalettedContainer blocks = section.states;
                    int minXIterate = currChunkX == minChunkX ? (minBlockX & 0xF) + sectionAdjust : 0;
                    int maxXIterate = currChunkX == maxChunkX ? (maxBlockX & 0xF) - sectionAdjust : 15;
                    int minZIterate = currChunkZ == minChunkZ ? (minBlockZ & 0xF) + sectionAdjust : 0;
                    int maxZIterate = currChunkZ == maxChunkZ ? (maxBlockZ & 0xF) - sectionAdjust : 15;
                    int minYIterate = currChunkY == minChunkY ? (minBlockY & 0xF) + sectionAdjust : 0;
                    int maxYIterate = currChunkY == maxChunkY ? (maxBlockY & 0xF) - sectionAdjust : 15;
                    for (int currY = minYIterate; currY <= maxYIterate; ++currY) {
                        int blockY = currY | currChunkY << 4;
                        mutablePos.setY(blockY);
                        for (int currZ = minZIterate; currZ <= maxZIterate; ++currZ) {
                            int blockZ = currZ | currChunkZ << 4;
                            mutablePos.setZ(blockZ);
                            for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                BlockState blockData;
                                double distance;
                                int edgeCount;
                                int localBlockIndex = currX | currZ << 4 | currY << 8;
                                int blockX = currX | currChunkX << 4;
                                mutablePos.setX(blockX);
                                int n = hasSpecial ? (blockX == minBlockX || blockX == maxBlockX ? 1 : 0) + (blockY == minBlockY || blockY == maxBlockY ? 1 : 0) + (blockZ == minBlockZ || blockZ == maxBlockZ ? 1 : 0) : (edgeCount = 0);
                                if (edgeCount == 3 || (distance = mutablePos.distToCenterSqr((Position)entityPos)) > selectedDistance || distance == selectedDistance && selected.compareTo((Vec3i)mutablePos) >= 0 || ((CollisionBlockState)(blockData = (BlockState)blocks.get(localBlockIndex))).moonrise$emptyContextCollisionShape()) continue;
                                VoxelShape blockCollision = ((CollisionBlockState)blockData).moonrise$getConstantContextCollisionShape();
                                if (edgeCount != 0 && (edgeCount == 1 && !blockData.hasLargeCollisionShape() || edgeCount == 2 && blockData.getBlock() != Blocks.MOVING_PISTON) || blockCollision == null && (blockCollision = blockData.getCollisionShape((BlockGetter)((Level)this), (BlockPos)mutablePos, (CollisionContext)collisionShape)).isEmpty()) continue;
                                AABB shiftedAABB = aabb.move(-((double)blockX), -((double)blockY), -((double)blockZ));
                                AABB singleAABB = ((CollisionVoxelShape)blockCollision).moonrise$getSingleAABBRepresentation();
                                if (singleAABB != null) {
                                    if (!CollisionUtil.voxelShapeIntersect(singleAABB, shiftedAABB)) continue;
                                    selected = mutablePos.immutable();
                                    selectedDistance = distance;
                                    continue;
                                }
                                if (!CollisionUtil.voxelShapeIntersectNoEmpty(blockCollision, shiftedAABB)) continue;
                                selected = mutablePos.immutable();
                                selectedDistance = distance;
                            }
                        }
                    }
                }
            }
        }
        return Optional.ofNullable(selected);
    }
}

