/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.collisions;

import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import ca.spottedleaf.moonrise.patches.collisions.ExplosionBlockCache;
import ca.spottedleaf.moonrise.patches.collisions.block.CollisionBlockState;
import ca.spottedleaf.moonrise.patches.getblock.GetBlockChunk;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerExplosion.class})
abstract class ServerExplosionMixin {
    @Shadow
    @Final
    private ServerLevel level;
    @Shadow
    @Final
    private ExplosionDamageCalculator damageCalculator;
    @Shadow
    @Final
    private float radius;
    @Shadow
    @Final
    private boolean fire;
    @Shadow
    @Final
    private Vec3 center;
    @Unique
    private static final double[] CACHED_RAYS;
    @Unique
    private static final int CHUNK_CACHE_SHIFT = 2;
    @Unique
    private static final int CHUNK_CACHE_MASK = 3;
    @Unique
    private static final int CHUNK_CACHE_WIDTH = 4;
    @Unique
    private static final int BLOCK_EXPLOSION_CACHE_SHIFT = 3;
    @Unique
    private static final int BLOCK_EXPLOSION_CACHE_MASK = 7;
    @Unique
    private static final int BLOCK_EXPLOSION_CACHE_WIDTH = 8;
    @Unique
    private static final Float ZERO_RESISTANCE;
    @Unique
    private Long2ObjectOpenHashMap<ExplosionBlockCache> blockCache = null;
    @Unique
    private long[] chunkPosCache = null;
    @Unique
    private LevelChunk[] chunkCache = null;
    @Unique
    private ExplosionBlockCache[] directMappedBlockCache;
    @Unique
    private BlockPos.MutableBlockPos mutablePos;

    ServerExplosionMixin() {
    }

    @Unique
    private ExplosionBlockCache getOrCacheExplosionBlock(int x, int y, int z, long key, boolean calculateResistance) {
        ExplosionBlockCache ret = (ExplosionBlockCache)this.blockCache.get(key);
        if (ret != null) {
            return ret;
        }
        BlockPos pos = new BlockPos(x, y, z);
        if (!this.level.isInWorldBounds(pos)) {
            ret = new ExplosionBlockCache(key, pos, null, null, 0.0f, true);
        } else {
            LevelChunk chunk;
            int chunkCacheKey = x >> 4 & 3 | z >> 4 << 2 & 0xC;
            long chunkKey = CoordinateUtils.getChunkKey(x >> 4, z >> 4);
            if (this.chunkPosCache[chunkCacheKey] == chunkKey) {
                chunk = this.chunkCache[chunkCacheKey];
            } else {
                this.chunkPosCache[chunkCacheKey] = chunkKey;
                this.chunkCache[chunkCacheKey] = chunk = this.level.getChunk(x >> 4, z >> 4);
            }
            BlockState blockState = ((GetBlockChunk)chunk).moonrise$getBlock(x, y, z);
            FluidState fluidState = blockState.getFluidState();
            Optional resistance = !calculateResistance ? Optional.empty() : this.damageCalculator.getBlockExplosionResistance((Explosion)this, (BlockGetter)this.level, pos, blockState, fluidState);
            ret = new ExplosionBlockCache(key, pos, blockState, fluidState, (resistance.orElse(ZERO_RESISTANCE).floatValue() + 0.3f) * 0.3f, false);
        }
        this.blockCache.put(key, (Object)ret);
        return ret;
    }

    @Unique
    private boolean clipsAnything(Vec3 from, Vec3 to, CollisionUtil.LazyEntityCollisionContext context, ExplosionBlockCache[] blockCache, BlockPos.MutableBlockPos currPos) {
        double adjX = 1.0E-7 * (from.x - to.x);
        double adjY = 1.0E-7 * (from.y - to.y);
        double adjZ = 1.0E-7 * (from.z - to.z);
        if (adjX == 0.0 && adjY == 0.0 && adjZ == 0.0) {
            return false;
        }
        double toXAdj = to.x - adjX;
        double toYAdj = to.y - adjY;
        double toZAdj = to.z - adjZ;
        double fromXAdj = from.x + adjX;
        double fromYAdj = from.y + adjY;
        double fromZAdj = from.z + adjZ;
        int currX = Mth.floor((double)fromXAdj);
        int currY = Mth.floor((double)fromYAdj);
        int currZ = Mth.floor((double)fromZAdj);
        double diffX = toXAdj - fromXAdj;
        double diffY = toYAdj - fromYAdj;
        double diffZ = toZAdj - fromZAdj;
        double dxDouble = Math.signum(diffX);
        double dyDouble = Math.signum(diffY);
        double dzDouble = Math.signum(diffZ);
        int dx = (int)dxDouble;
        int dy = (int)dyDouble;
        int dz = (int)dzDouble;
        double normalizedDiffX = diffX == 0.0 ? Double.MAX_VALUE : dxDouble / diffX;
        double normalizedDiffY = diffY == 0.0 ? Double.MAX_VALUE : dyDouble / diffY;
        double normalizedDiffZ = diffZ == 0.0 ? Double.MAX_VALUE : dzDouble / diffZ;
        double normalizedCurrX = normalizedDiffX * (diffX > 0.0 ? 1.0 - Mth.frac((double)fromXAdj) : Mth.frac((double)fromXAdj));
        double normalizedCurrY = normalizedDiffY * (diffY > 0.0 ? 1.0 - Mth.frac((double)fromYAdj) : Mth.frac((double)fromYAdj));
        double normalizedCurrZ = normalizedDiffZ * (diffZ > 0.0 ? 1.0 - Mth.frac((double)fromZAdj) : Mth.frac((double)fromZAdj));
        while (true) {
            BlockState blockState;
            currPos.set(currX, currY, currZ);
            long key = BlockPos.asLong((int)currX, (int)currY, (int)currZ);
            int cacheKey = currX & 7 | (currY & 7) << 3 | (currZ & 7) << 6;
            ExplosionBlockCache cachedBlock = blockCache[cacheKey];
            if (cachedBlock == null || cachedBlock.key != key) {
                blockCache[cacheKey] = cachedBlock = this.getOrCacheExplosionBlock(currX, currY, currZ, key, false);
            }
            if ((blockState = cachedBlock.blockState) != null && !((CollisionBlockState)blockState).moonrise$emptyContextCollisionShape()) {
                VoxelShape collision = cachedBlock.cachedCollisionShape;
                if (collision == null) {
                    collision = ((CollisionBlockState)blockState).moonrise$getConstantContextCollisionShape();
                    if (collision == null) {
                        collision = blockState.getCollisionShape((BlockGetter)this.level, (BlockPos)currPos, (CollisionContext)context);
                        if (!context.isDelegated()) {
                            cachedBlock.cachedCollisionShape = collision;
                        }
                    } else {
                        cachedBlock.cachedCollisionShape = collision;
                    }
                }
                if (!collision.isEmpty() && collision.clip(from, to, (BlockPos)currPos) != null) {
                    return true;
                }
            }
            if (normalizedCurrX > 1.0 && normalizedCurrY > 1.0 && normalizedCurrZ > 1.0) {
                return false;
            }
            if (normalizedCurrX < normalizedCurrY) {
                if (normalizedCurrX < normalizedCurrZ) {
                    currX += dx;
                    normalizedCurrX += normalizedDiffX;
                    continue;
                }
                currZ += dz;
                normalizedCurrZ += normalizedDiffZ;
                continue;
            }
            if (normalizedCurrY < normalizedCurrZ) {
                currY += dy;
                normalizedCurrY += normalizedDiffY;
                continue;
            }
            currZ += dz;
            normalizedCurrZ += normalizedDiffZ;
        }
    }

    @Unique
    private float getSeenFraction(Vec3 source, Entity target, ExplosionBlockCache[] blockCache, BlockPos.MutableBlockPos blockPos) {
        AABB boundingBox = target.getBoundingBox();
        double diffX = boundingBox.maxX - boundingBox.minX;
        double diffY = boundingBox.maxY - boundingBox.minY;
        double diffZ = boundingBox.maxZ - boundingBox.minZ;
        double incX = 1.0 / (diffX * 2.0 + 1.0);
        double incY = 1.0 / (diffY * 2.0 + 1.0);
        double incZ = 1.0 / (diffZ * 2.0 + 1.0);
        if (incX < 0.0 || incY < 0.0 || incZ < 0.0) {
            return 0.0f;
        }
        double offX = (1.0 - Math.floor(1.0 / incX) * incX) * 0.5 + boundingBox.minX;
        double offY = boundingBox.minY;
        double offZ = (1.0 - Math.floor(1.0 / incZ) * incZ) * 0.5 + boundingBox.minZ;
        CollisionUtil.LazyEntityCollisionContext context = new CollisionUtil.LazyEntityCollisionContext(target);
        int totalRays = 0;
        int missedRays = 0;
        for (double dx = 0.0; dx <= 1.0; dx += incX) {
            double fromX = Math.fma(dx, diffX, offX);
            for (double dy = 0.0; dy <= 1.0; dy += incY) {
                double fromY = Math.fma(dy, diffY, offY);
                for (double dz = 0.0; dz <= 1.0; dz += incZ) {
                    ++totalRays;
                    Vec3 from = new Vec3(fromX, fromY, Math.fma(dz, diffZ, offZ));
                    if (this.clipsAnything(from, source, context, blockCache, blockPos)) continue;
                    ++missedRays;
                }
            }
        }
        return (float)missedRays / (float)totalRays;
    }

    @Inject(method={"explode"}, at={@At(value="HEAD")})
    private void initCacheFields(CallbackInfoReturnable<Integer> cir) {
        this.blockCache = new Long2ObjectOpenHashMap();
        this.chunkPosCache = new long[16];
        Arrays.fill(this.chunkPosCache, ChunkPos.INVALID_CHUNK_POS);
        this.chunkCache = new LevelChunk[16];
        this.directMappedBlockCache = new ExplosionBlockCache[512];
        this.mutablePos = new BlockPos.MutableBlockPos();
    }

    @Overwrite
    public List<BlockPos> calculateExplodedPositions() {
        ObjectArrayList ret = new ObjectArrayList();
        Vec3 center = this.center;
        ExplosionBlockCache[] blockCache = this.directMappedBlockCache;
        int blockX = Mth.floor((double)center.x);
        int blockY = Mth.floor((double)center.y);
        int blockZ = Mth.floor((double)center.z);
        long key = BlockPos.asLong((int)blockX, (int)blockY, (int)blockZ);
        ExplosionBlockCache initialCache = this.getOrCacheExplosionBlock(blockX, blockY, blockZ, key, true);
        int ray = 0;
        int len = CACHED_RAYS.length;
        block0: while (ray < len) {
            ExplosionBlockCache cachedBlock = initialCache;
            double currX = center.x;
            double currY = center.y;
            double currZ = center.z;
            double incX = CACHED_RAYS[ray];
            double incY = CACHED_RAYS[ray + 1];
            double incZ = CACHED_RAYS[ray + 2];
            ray += 3;
            float power = this.radius * (0.7f + this.level.random.nextFloat() * 0.6f);
            do {
                int cacheKey;
                int blockZ2;
                int blockY2;
                int blockX2;
                long key2;
                if (cachedBlock.key != (key2 = BlockPos.asLong((int)(blockX2 = Mth.floor((double)currX)), (int)(blockY2 = Mth.floor((double)currY)), (int)(blockZ2 = Mth.floor((double)currZ)))) && ((cachedBlock = blockCache[cacheKey = blockX2 & 7 | (blockY2 & 7) << 3 | (blockZ2 & 7) << 6]) == null || cachedBlock.key != key2)) {
                    blockCache[cacheKey] = cachedBlock = this.getOrCacheExplosionBlock(blockX2, blockY2, blockZ2, key2, true);
                }
                if (cachedBlock.outOfWorld) continue block0;
                if ((power -= cachedBlock.resistance) > 0.0f && cachedBlock.shouldExplode == null) {
                    boolean shouldExplode = this.damageCalculator.shouldBlockExplode((Explosion)this, (BlockGetter)this.level, cachedBlock.immutablePos, cachedBlock.blockState, power);
                    Boolean bl = cachedBlock.shouldExplode = shouldExplode ? Boolean.TRUE : Boolean.FALSE;
                    if (shouldExplode && (this.fire || !cachedBlock.blockState.isAir())) {
                        ret.add((Object)cachedBlock.immutablePos);
                    }
                }
                currX += incX;
                currY += incY;
                currZ += incZ;
            } while ((power -= 0.22500001f) > 0.0f);
        }
        return ret;
    }

    @Redirect(method={"hurtEntities()V", "hurtEntities(Ljava/util/List;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/ServerExplosion;getSeenPercent(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/entity/Entity;)F"))
    private float useBetterSeenPercent(Vec3 center, Entity target) {
        return this.getSeenFraction(center, target, this.directMappedBlockCache, this.mutablePos);
    }

    @Inject(method={"explode"}, at={@At(value="RETURN")})
    private void destroyCacheFields(CallbackInfoReturnable<Integer> cir) {
        this.blockCache = null;
        this.chunkPosCache = null;
        this.chunkCache = null;
        this.directMappedBlockCache = null;
        this.mutablePos = null;
    }

    static {
        DoubleArrayList rayCoords = new DoubleArrayList();
        for (int x = 0; x <= 15; ++x) {
            for (int y = 0; y <= 15; ++y) {
                for (int z = 0; z <= 15; ++z) {
                    if (x != 0 && x != 15 && y != 0 && y != 15 && z != 0 && z != 15) continue;
                    double xDir = (float)x / 15.0f * 2.0f - 1.0f;
                    double yDir = (float)y / 15.0f * 2.0f - 1.0f;
                    double zDir = (float)z / 15.0f * 2.0f - 1.0f;
                    double mag = Math.sqrt(xDir * xDir + yDir * yDir + zDir * zDir);
                    rayCoords.add(xDir / mag * (double)0.3f);
                    rayCoords.add(yDir / mag * (double)0.3f);
                    rayCoords.add(zDir / mag * (double)0.3f);
                }
            }
        }
        CACHED_RAYS = rayCoords.toDoubleArray();
        ZERO_RESISTANCE = Float.valueOf(-0.3f);
    }
}

