/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.fluid;

import ca.spottedleaf.moonrise.patches.fluid.FluidFluidState;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={FluidState.class})
abstract class FluidStateMixin
extends StateHolder<Fluid, FluidState>
implements FluidFluidState {
    @Unique
    private int amount;
    @Unique
    private boolean isEmpty;
    @Unique
    private boolean isSource;
    @Unique
    private float ownHeight;
    @Unique
    private boolean isRandomlyTicking;
    @Unique
    private BlockState legacyBlock;

    @Shadow
    public abstract Fluid getType();

    protected FluidStateMixin(Fluid object, Reference2ObjectArrayMap<Property<?>, Comparable<?>> reference2ObjectArrayMap, MapCodec<FluidState> mapCodec) {
        super((Object)object, reference2ObjectArrayMap, mapCodec);
    }

    @Override
    public final void moonrise$initCaches() {
        this.amount = this.getType().getAmount((FluidState)this);
        this.isEmpty = this.getType().isEmpty();
        this.isSource = this.getType().isSource((FluidState)this);
        this.ownHeight = this.getType().getOwnHeight((FluidState)this);
        this.isRandomlyTicking = this.getType().isRandomlyTicking();
    }

    @Overwrite
    public int getAmount() {
        return this.amount;
    }

    @Overwrite
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Overwrite
    public boolean isSource() {
        return this.isSource;
    }

    @Overwrite
    public float getOwnHeight() {
        return this.ownHeight;
    }

    @Overwrite
    public boolean isSourceOfType(Fluid other) {
        return this.isSource && this.owner == other;
    }

    @Overwrite
    public BlockState createLegacyBlock() {
        if (this.legacyBlock != null) {
            return this.legacyBlock;
        }
        this.legacyBlock = this.getType().createLegacyBlock((FluidState)this);
        return this.legacyBlock;
    }

    @Overwrite
    public boolean isRandomlyTicking() {
        return this.isRandomlyTicking;
    }
}

