/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.mob_spawning;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.LocalMobCapCalculator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LocalMobCapCalculator.MobCounts.class})
abstract class LocalMobCapCalculator$MobCountsMixin {
    @Shadow
    @Mutable
    @Final
    private Object2IntMap<MobCategory> counts;
    @Unique
    private static final MobCategory[] CATEGORIES = MobCategory.values();
    @Unique
    private static final Object2IntOpenHashMap<?> DUMMY = new Object2IntOpenHashMap();
    @Unique
    private final int[] newCounts = new int[CATEGORIES.length];

    LocalMobCapCalculator$MobCountsMixin() {
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void destroyField(CallbackInfo ci) {
        this.counts = null;
    }

    @Redirect(method={"<init>"}, at=@At(value="NEW", target="(I)Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;"))
    private <T> Object2IntOpenHashMap<T> avoidAllocation(int expected) {
        return DUMMY;
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/MobCategory;values()[Lnet/minecraft/world/entity/MobCategory;"))
    private MobCategory[] useCachedArray() {
        return CATEGORIES;
    }

    @Overwrite
    public void add(MobCategory category) {
        int n = category.ordinal();
        this.newCounts[n] = this.newCounts[n] + 1;
    }

    @Overwrite
    public boolean canSpawn(MobCategory category) {
        return this.newCounts[category.ordinal()] < category.getMaxInstancesPerChunk();
    }
}

