/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.poi_lookup;

import ca.spottedleaf.moonrise.patches.poi_lookup.PoiAccess;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.portal.PortalForcer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={PortalForcer.class})
abstract class PortalForcerMixin {
    @Shadow
    @Final
    private ServerLevel level;

    PortalForcerMixin() {
    }

    @Overwrite
    public Optional<BlockPos> findClosestPortalPosition(BlockPos blockPos, boolean bl, WorldBorder worldBorder) {
        PoiManager poiManager = this.level.getPoiManager();
        int i = bl ? 16 : 128;
        ArrayList<PoiRecord> records = new ArrayList<PoiRecord>();
        PoiAccess.findClosestPoiDataRecords(poiManager, type -> type.is(PoiTypes.NETHER_PORTAL), pos -> {
            BelowZeroRetrogen belowZeroRetrogen;
            ChunkAccess lowest = this.level.getChunk(pos.getX() >> 4, pos.getZ() >> 4, ChunkStatus.EMPTY);
            if (!(lowest.getPersistedStatus().isOrAfter(ChunkStatus.FULL) || (belowZeroRetrogen = lowest.getBelowZeroRetrogen()) != null && belowZeroRetrogen.targetStatus().isOrAfter(ChunkStatus.SPAWN))) {
                return false;
            }
            if (!worldBorder.isWithinBounds(pos)) {
                return false;
            }
            return lowest.getBlockState(pos).hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS);
        }, blockPos, i, Double.MAX_VALUE, PoiManager.Occupancy.ANY, true, records);
        PoiRecord lowestYRecord = null;
        for (PoiRecord record : records) {
            if (lowestYRecord == null) {
                lowestYRecord = record;
                continue;
            }
            if (lowestYRecord.getPos().getY() <= record.getPos().getY()) continue;
            lowestYRecord = record;
        }
        return Optional.ofNullable(lowestYRecord == null ? null : lowestYRecord.getPos());
    }
}

