/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.serverlist;

import ca.spottedleaf.moonrise.patches.serverlist.ServerListConnection;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Connection.class})
abstract class ConnectionMixin
extends SimpleChannelInboundHandler<Packet<?>>
implements ServerListConnection {
    @Shadow
    private Channel channel;
    @Unique
    private static final String TIMEOUT_PIPELINE_NAME = "timeout";
    @Unique
    private static final int DEFAULT_TIMEOUT = 30;
    @Unique
    private volatile int timeout = 30;

    ConnectionMixin() {
    }

    @Override
    public final int moonrise$getReadTimeout() {
        return this.timeout;
    }

    @Override
    public final void moonrise$setReadTimeout(int seconds) {
        if (this.channel != null) {
            this.channel.eventLoop().execute(() -> {
                this.timeout = seconds;
                if (this.channel != null) {
                    this.channel.pipeline().replace(TIMEOUT_PIPELINE_NAME, TIMEOUT_PIPELINE_NAME, (ChannelHandler)new ReadTimeoutHandler(seconds));
                    this.channel.pipeline().channel().config().setOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)(seconds * 1000));
                }
            });
        } else {
            this.timeout = seconds;
        }
    }

    @Inject(method={"configurePacketHandler"}, at={@At(value="RETURN")})
    private void delayedTimeout(ChannelPipeline pipeline, CallbackInfo ci) {
        int timeout = this.timeout;
        if (timeout != 30) {
            pipeline.replace(TIMEOUT_PIPELINE_NAME, TIMEOUT_PIPELINE_NAME, (ChannelHandler)new ReadTimeoutHandler(timeout));
            pipeline.channel().config().setOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)(timeout * 1000));
        }
    }
}

