/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.starlight.world;

import ca.spottedleaf.moonrise.common.util.MixinWorkarounds;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.starlight.chunk.StarlightChunk;
import ca.spottedleaf.moonrise.patches.starlight.light.SWMRNibbleArray;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightEngine;
import ca.spottedleaf.moonrise.patches.starlight.storage.StarlightSectionData;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SerializableChunkData.class})
abstract class SerializableChunkDataMixin {
    @Shadow
    @Final
    private ChunkStatus chunkStatus;
    @Shadow
    @Final
    private boolean lightCorrect;
    @Shadow
    @Final
    private List<SerializableChunkData.SectionData> sectionData;
    @Shadow
    @Final
    private static Logger LOGGER;

    SerializableChunkDataMixin() {
    }

    @Redirect(method={"parse"}, at=@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;getBooleanOr(Ljava/lang/String;Z)Z", ordinal=0))
    private static boolean setLightCorrect(CompoundTag instance, String string, boolean dfl, @Local(ordinal=0, argsOnly=false) ChunkStatus status) {
        boolean starlightCorrect = instance.get("isLightOn") != null && instance.getIntOr("starlight.light_version", -1) == 10;
        return status.isOrAfter(ChunkStatus.LIGHT) && starlightCorrect;
    }

    @Redirect(method={"parse"}, at=@At(value="NEW", target="(ILnet/minecraft/world/level/chunk/LevelChunkSection;Lnet/minecraft/world/level/chunk/DataLayer;Lnet/minecraft/world/level/chunk/DataLayer;)Lnet/minecraft/world/level/chunk/storage/SerializableChunkData$SectionData;", ordinal=0))
    private static SerializableChunkData.SectionData readStarlightState(int y, LevelChunkSection chunkSection, DataLayer blockLight, DataLayer skyLight, @Local(ordinal=2, argsOnly=false) CompoundTag sectionData) {
        SerializableChunkData.SectionData ret = new SerializableChunkData.SectionData(y, chunkSection, blockLight, skyLight);
        if (sectionData.contains("starlight.blocklight_state")) {
            ((StarlightSectionData)ret).starlight$setBlockLightState(sectionData.getIntOr("starlight.blocklight_state", 0));
        }
        if (sectionData.contains("starlight.skylight_state")) {
            ((StarlightSectionData)ret).starlight$setSkyLightState(sectionData.getIntOr("starlight.skylight_state", 0));
        }
        return ret;
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private void loadStarlightLightData(ServerLevel world, PoiManager poiManager, RegionStorageInfo regionStorageInfo, ChunkPos pos, CallbackInfoReturnable<ProtoChunk> cir) {
        ProtoChunk ret = (ProtoChunk)cir.getReturnValue();
        boolean hasSkyLight = world.dimensionType().hasSkyLight();
        int minSection = WorldUtil.getMinLightSection((LevelHeightAccessor)world);
        SWMRNibbleArray[] blockNibbles = StarLightEngine.getFilledEmptyLight((LevelHeightAccessor)world);
        SWMRNibbleArray[] skyNibbles = StarLightEngine.getFilledEmptyLight((LevelHeightAccessor)world);
        if (!this.lightCorrect) {
            ((StarlightChunk)ret).starlight$setBlockNibbles(blockNibbles);
            ((StarlightChunk)ret).starlight$setSkyNibbles(skyNibbles);
            return;
        }
        try {
            for (SerializableChunkData.SectionData sectionData : this.sectionData) {
                int y = sectionData.y();
                DataLayer blockLight = sectionData.blockLight();
                DataLayer skyLight = sectionData.skyLight();
                int blockState = ((StarlightSectionData)sectionData).starlight$getBlockLightState();
                int skyState = ((StarlightSectionData)sectionData).starlight$getSkyLightState();
                if (blockState >= 0) {
                    blockNibbles[y - minSection] = blockLight != null ? new SWMRNibbleArray(MixinWorkarounds.clone(blockLight.getData()), blockState) : new SWMRNibbleArray(null, blockState);
                }
                if (skyState < 0 || !hasSkyLight) continue;
                if (skyLight != null) {
                    skyNibbles[y - minSection] = new SWMRNibbleArray(MixinWorkarounds.clone(skyLight.getData()), skyState);
                    continue;
                }
                skyNibbles[y - minSection] = new SWMRNibbleArray(null, skyState);
            }
            ((StarlightChunk)ret).starlight$setBlockNibbles(blockNibbles);
            ((StarlightChunk)ret).starlight$setSkyNibbles(skyNibbles);
        }
        catch (Throwable thr) {
            ret.setLightCorrect(false);
            LOGGER.error("Failed to parse light data for chunk " + String.valueOf(ret.getPos()) + " in world '" + WorldUtil.getWorldName((Level)world) + "'", thr);
        }
    }

    @Redirect(method={"copyOf"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/lighting/LevelLightEngine;getMinLightSection()I", ordinal=0))
    private static int rewriteSectionCopy(LevelLightEngine instance, @Local(ordinal=0, argsOnly=true) ServerLevel world, @Local(ordinal=0, argsOnly=true) ChunkAccess chunk, @Local(ordinal=0, argsOnly=false) List<SerializableChunkData.SectionData> sections) {
        int minLightSection = WorldUtil.getMinLightSection((LevelHeightAccessor)world);
        int maxLightSection = WorldUtil.getMaxLightSection((LevelHeightAccessor)world);
        int minBlockSection = WorldUtil.getMinSection((Level)world);
        LevelChunkSection[] chunkSections = chunk.getSections();
        SWMRNibbleArray[] blockNibbles = ((StarlightChunk)chunk).starlight$getBlockNibbles();
        SWMRNibbleArray[] skyNibbles = ((StarlightChunk)chunk).starlight$getSkyNibbles();
        for (int lightSection = minLightSection; lightSection <= maxLightSection; ++lightSection) {
            int lightSectionIdx = lightSection - minLightSection;
            int blockSectionIdx = lightSection - minBlockSection;
            LevelChunkSection chunkSection = blockSectionIdx >= 0 && blockSectionIdx < chunkSections.length ? chunkSections[blockSectionIdx].copy() : null;
            SWMRNibbleArray.SaveState blockNibble = blockNibbles[lightSectionIdx].getSaveState();
            SWMRNibbleArray.SaveState skyNibble = skyNibbles[lightSectionIdx].getSaveState();
            if (chunkSection == null && blockNibble == null && skyNibble == null) continue;
            SerializableChunkData.SectionData sectionData = new SerializableChunkData.SectionData(lightSection, chunkSection, blockNibble == null ? null : (blockNibble.data == null ? null : new DataLayer(blockNibble.data)), skyNibble == null ? null : (skyNibble.data == null ? null : new DataLayer(skyNibble.data)));
            if (blockNibble != null) {
                ((StarlightSectionData)sectionData).starlight$setBlockLightState(blockNibble.state);
            }
            if (skyNibble != null) {
                ((StarlightSectionData)sectionData).starlight$setSkyLightState(skyNibble.state);
            }
            sections.add(sectionData);
        }
        return Integer.MAX_VALUE;
    }

    @Inject(method={"write"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/chunk/storage/SerializableChunkData$SectionData;chunkSection:Lnet/minecraft/world/level/chunk/LevelChunkSection;", ordinal=0)})
    private void storeStarlightState(CallbackInfoReturnable<CompoundTag> cir, @Local(ordinal=0, argsOnly=false) SerializableChunkData.SectionData sectionData, @Local(ordinal=1, argsOnly=false) CompoundTag sectionNBT) {
        int blockState = ((StarlightSectionData)sectionData).starlight$getBlockLightState();
        int skyState = ((StarlightSectionData)sectionData).starlight$getSkyLightState();
        if (blockState > 0) {
            sectionNBT.putInt("starlight.blocklight_state", blockState);
        }
        if (skyState > 0) {
            sectionNBT.putInt("starlight.skylight_state", skyState);
        }
    }

    @Inject(method={"write"}, at={@At(value="RETURN")})
    private void writeStarlightCorrectLight(CallbackInfoReturnable<CompoundTag> cir) {
        if (this.chunkStatus.isBefore(ChunkStatus.LIGHT) || !this.lightCorrect) {
            return;
        }
        CompoundTag ret = (CompoundTag)cir.getReturnValue();
        ret.putBoolean("isLightOn", false);
        ret.putInt("starlight.light_version", 10);
    }
}

