/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.tick_loop;

import ca.spottedleaf.moonrise.common.config.moonrise.MoonriseConfig;
import ca.spottedleaf.moonrise.common.time.Schedule;
import ca.spottedleaf.moonrise.common.time.TickData;
import ca.spottedleaf.moonrise.common.time.TickTime;
import ca.spottedleaf.moonrise.common.util.ConfigHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.server.ChunkSystemMinecraftServer;
import ca.spottedleaf.moonrise.patches.tick_loop.TickLoopBlockableEventLoop;
import ca.spottedleaf.moonrise.patches.tick_loop.TickLoopMinecraftServer;
import ca.spottedleaf.moonrise.patches.tick_loop.TickLoopPacketProcessor;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import net.minecraft.Util;
import net.minecraft.commands.CommandSource;
import net.minecraft.network.PacketProcessor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerInfo;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
abstract class MinecraftServerMixin
extends ReentrantBlockableEventLoop<TickTask>
implements ServerInfo,
CommandSource,
ChunkIOErrorReporter,
TickLoopMinecraftServer {
    @Shadow
    @Final
    private PacketProcessor packetProcessor;
    @Shadow
    private long nextTickTimeNanos;
    @Shadow
    @Final
    private ServerTickRateManager tickRateManager;
    @Shadow
    private long lastOverloadWarningNanos;
    @Shadow
    private boolean waitingForNextTick;
    @Shadow
    private long idleTimeNanos;
    @Unique
    private final Schedule tickSchedule = new Schedule(0L);
    @Unique
    private final TickData tickTimes5s = new TickData(TimeUnit.SECONDS.toNanos(5L));
    @Unique
    private final TickData tickTimes10s = new TickData(TimeUnit.SECONDS.toNanos(10L));
    @Unique
    private final TickData tickTimes1m = new TickData(TimeUnit.MINUTES.toNanos(1L));
    @Unique
    private final TickData tickTimes5m = new TickData(TimeUnit.MINUTES.toNanos(5L));
    @Unique
    private final TickData tickTimes15m = new TickData(TimeUnit.MINUTES.toNanos(15L));
    @Unique
    private long lastTickStart;
    @Unique
    private long currentTickStart;
    @Unique
    private long scheduledTickStart;
    @Unique
    private long taskExecutionTime;

    @Shadow
    public abstract Iterable<ServerLevel> getAllLevels();

    @Shadow
    public abstract boolean isPaused();

    @Shadow
    protected abstract void startMeasuringTaskExecutionTime();

    @Shadow
    protected abstract void finishMeasuringTaskExecutionTime();

    @Shadow
    public abstract boolean pollTask();

    @Shadow
    public abstract boolean isTickTimeLoggingEnabled();

    public MinecraftServerMixin(String name) {
        super(name);
    }

    @Override
    public final TickData moonrise$getTickData5s() {
        return this.tickTimes5s;
    }

    @Override
    public final TickData moonrise$getTickData10s() {
        return this.tickTimes10s;
    }

    @Override
    public final TickData moonrise$getTickData1m() {
        return this.tickTimes1m;
    }

    @Override
    public final TickData moonrise$getTickData5m() {
        return this.tickTimes5m;
    }

    @Override
    public final TickData moonrise$getTickData15m() {
        return this.tickTimes15m;
    }

    @Unique
    private void addTickTime(TickTime time) {
        this.tickTimes5s.addDataFrom(time);
        this.tickTimes10s.addDataFrom(time);
        this.tickTimes1m.addDataFrom(time);
        this.tickTimes5m.addDataFrom(time);
        this.tickTimes15m.addDataFrom(time);
    }

    @Inject(method={"runServer"}, at={@At(value="FIELD", target="Lnet/minecraft/server/MinecraftServer;nextTickTimeNanos:J", opcode=181, ordinal=0, shift=At.Shift.AFTER)})
    private void initTickSchedule(CallbackInfo ci) {
        long interval = this.isPaused() || !this.tickRateManager.isSprinting() ? this.tickRateManager.nanosecondsPerTick() : 0L;
        this.tickSchedule.setNextPeriod(this.nextTickTimeNanos, interval);
        this.lastTickStart = Long.MIN_VALUE;
        this.scheduledTickStart = this.tickSchedule.getDeadline(interval);
    }

    @Redirect(method={"runServer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;isPaused()Z", ordinal=0))
    private boolean shortSprintBranch(MinecraftServer instance) {
        return true;
    }

    @Redirect(method={"runServer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/ServerTickRateManager;nanosecondsPerTick()J", ordinal=0))
    private long updateTickSchedule(ServerTickRateManager tickRateManager) {
        long interval;
        boolean sprint;
        long now = Util.getNanos();
        boolean bl = sprint = !this.isPaused() && tickRateManager.isSprinting() && tickRateManager.checkShouldSprintThisTick();
        if (sprint) {
            interval = 0L;
            this.tickSchedule.setNextPeriod(now, interval);
        } else {
            long catchup;
            interval = tickRateManager.nanosecondsPerTick();
            long ticksBehind = Math.max(1L, this.tickSchedule.getPeriodsAhead(interval, now));
            if (ticksBehind > (catchup = (long)Math.max(1, ConfigHolder.getConfig().tickLoop.catchupTicks.getOrDefault(MoonriseConfig.TickLoop.DEFAULT_CATCHUP_TICKS)))) {
                long difference = ticksBehind - catchup;
                this.tickSchedule.advanceBy(difference, interval);
            }
            this.tickSchedule.advanceBy(1L, interval);
        }
        this.lastOverloadWarningNanos = this.nextTickTimeNanos = this.tickSchedule.getDeadline(interval);
        this.currentTickStart = now;
        return interval;
    }

    @Inject(method={"runServer"}, at={@At(value="INVOKE", target="Lcom/mojang/jtracy/DiscontinuousFrame;end()V", ordinal=0, shift=At.Shift.AFTER)})
    private void hookEndOfTick(CallbackInfo ci) {
        long prevStart = this.lastTickStart;
        long currStart = this.currentTickStart;
        this.lastTickStart = this.currentTickStart;
        long scheduledStart = this.scheduledTickStart;
        this.scheduledTickStart = this.nextTickTimeNanos;
        long now = Util.getNanos();
        TickTime time = new TickTime(prevStart, scheduledStart, currStart, 0L, now, 0L, this.taskExecutionTime, 0L, false);
        this.taskExecutionTime = 0L;
        this.addTickTime(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"runServer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;waitUntilNextTick()V", ordinal=0))
    private void recordTaskExecutionTimeWhileWaiting(MinecraftServer instance) {
        ProfilerFiller profiler = Profiler.get();
        profiler.push("moonrise:execute_tasks_until_tick");
        this.waitingForNextTick = true;
        boolean isLoggingEnabled = this.isTickTimeLoggingEnabled();
        try {
            long deadline = this.nextTickTimeNanos;
            while (true) {
                long start;
                if ((start = Util.getNanos()) - deadline >= 0L) {
                } else {
                    while (this.pollTask() && Util.getNanos() - deadline < 0L) {
                    }
                    long now = Util.getNanos();
                    this.taskExecutionTime += now - start;
                    long toWait = deadline - now;
                    if (toWait > 0L) {
                        LockSupport.parkNanos("waiting for tick or tasks", toWait);
                        if (!isLoggingEnabled) continue;
                        this.idleTimeNanos += Util.getNanos() - now;
                        continue;
                    }
                }
                break;
            }
        }
        finally {
            this.waitingForNextTick = false;
        }
        profiler.pop();
    }

    @Redirect(method={"runServer"}, at=@At(value="FIELD", target="Lnet/minecraft/server/MinecraftServer;nextTickTimeNanos:J", opcode=181, ordinal=3))
    private void dropNextTickTimeInc(MinecraftServer instance, long value) {
    }

    @ModifyConstant(method={"shouldRun(Lnet/minecraft/server/TickTask;)Z"}, constant={@Constant(intValue=3, ordinal=0)})
    private int changeMaxTaskDelay(int constant) {
        return 1;
    }

    @Redirect(method={"runServer"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/PacketProcessor;processQueuedPackets()V"))
    private void dropVanillaPacketProcessing(PacketProcessor instance) {
    }

    @Inject(method={"runServer"}, at={@At(value="INVOKE", target="Lcom/mojang/jtracy/DiscontinuousFrame;start()V", shift=At.Shift.AFTER)})
    private void runAllTasksAtStart(CallbackInfo ci) {
        this.startMeasuringTaskExecutionTime();
        ProfilerFiller profiler = Profiler.get();
        profiler.push("moonrise:run_all_tasks");
        profiler.push("moonrise:run_all_server");
        while (super.pollTask()) {
            ((ChunkSystemMinecraftServer)((Object)this)).moonrise$executeMidTickTasks();
            ((TickLoopPacketProcessor)this.packetProcessor).moonrise$executeSinglePacket();
        }
        profiler.popPush("moonrise:run_all_packets");
        while (((TickLoopPacketProcessor)this.packetProcessor).moonrise$executeSinglePacket()) {
            ((ChunkSystemMinecraftServer)((Object)this)).moonrise$executeMidTickTasks();
        }
        profiler.popPush("moonrise:run_all_chunk");
        for (ServerLevel world : this.getAllLevels()) {
            profiler.push(world.toString() + " " + String.valueOf(world.dimension().location()));
            profiler.push("moonrise:distance_manager_update");
            ((ChunkSystemServerLevel)world).moonrise$getChunkTaskScheduler().chunkHolderManager.processTicketUpdates();
            profiler.popPush("moonrise:legacy_chunk_tasks");
            ((TickLoopBlockableEventLoop)world.getChunkSource().mainThreadProcessor).moonrise$executeAllRecentInternalTasks();
            profiler.popPush("moonrise:chunk_system_tasks");
            ((ChunkSystemServerLevel)world).moonrise$getChunkTaskScheduler().executeAllRecentlyQueuedMainThreadTasks();
            profiler.pop();
            profiler.pop();
        }
        profiler.pop();
        profiler.pop();
        this.finishMeasuringTaskExecutionTime();
    }

    @Overwrite
    public void waitUntilNextTick() {
        ProfilerFiller profiler = Profiler.get();
        profiler.push("moonrise:wait_for_next_tick");
        this.waitingForNextTick = true;
        try {
            this.managedBlock(() -> Util.getNanos() - this.nextTickTimeNanos >= 0L);
        }
        finally {
            this.waitingForNextTick = false;
        }
        profiler.pop();
    }

    @WrapOperation(method={"pollTask"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;pollTaskInternal()Z")})
    private boolean makePollExecutePacket(MinecraftServer instance, Operation<Boolean> original) {
        return ((TickLoopPacketProcessor)instance.packetProcessor()).moonrise$executeSinglePacket() | (Boolean)original.call(new Object[]{instance});
    }
}

