/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.profiler;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class LProfileGraph {
    public static final int ROOT_NODE = 0;
    private Int2IntOpenHashMap[] nodes;
    private int nodeCount;

    public LProfileGraph() {
        Int2IntOpenHashMap[] nodes = new Int2IntOpenHashMap[16];
        nodes[0] = new Int2IntOpenHashMap();
        this.nodes = nodes;
        this.nodeCount = 1;
    }

    public List<GraphNode> getDFS() {
        GraphNode graphNode;
        ArrayList<GraphNode> ret = new ArrayList<GraphNode>();
        ArrayDeque<GraphNode> queue = new ArrayDeque<GraphNode>();
        queue.addFirst(new GraphNode(null, 0, -1));
        Int2IntOpenHashMap[] nodes = this.nodes;
        while ((graphNode = (GraphNode)queue.pollFirst()) != null) {
            ret.add(graphNode);
            int parent = graphNode.nodeId;
            Int2IntOpenHashMap children = nodes[parent];
            ObjectIterator iterator = children.int2IntEntrySet().fastIterator();
            while (iterator.hasNext()) {
                Int2IntMap.Entry entry = (Int2IntMap.Entry)iterator.next();
                queue.addFirst(new GraphNode(graphNode, entry.getIntValue(), entry.getIntKey()));
            }
        }
        return ret;
    }

    private int createNode(int parent, int timerId) {
        int newNode;
        int prev;
        Int2IntOpenHashMap[] nodes = this.nodes;
        Int2IntOpenHashMap node = nodes[parent];
        if ((prev = node.putIfAbsent(timerId, newNode = this.nodeCount++)) != 0) {
            return prev;
        }
        if (newNode >= nodes.length) {
            this.nodes = nodes = Arrays.copyOf(nodes, nodes.length * 2);
        }
        nodes[newNode] = new Int2IntOpenHashMap();
        return newNode;
    }

    public int getNode(int parent, int timerId) {
        Int2IntOpenHashMap[] nodes = this.nodes;
        if (parent >= nodes.length) {
            return -1;
        }
        int mapping = nodes[parent].get(timerId);
        if (mapping != 0) {
            return mapping;
        }
        return -1;
    }

    public int getOrCreateNode(int parent, int timerId) {
        Int2IntOpenHashMap[] nodes = this.nodes;
        int mapping = nodes[parent].get(timerId);
        if (mapping != 0) {
            return mapping;
        }
        return this.createNode(parent, timerId);
    }

    public record GraphNode(GraphNode parent, int nodeId, int timerId) {
    }
}

