/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common;

import ca.spottedleaf.moonrise.common.util.ChunkSystemHooks;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixer;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;

public interface PlatformHooks
extends ChunkSystemHooks {
    public static PlatformHooks get() {
        return Holder.INSTANCE;
    }

    public String getBrand();

    public int getLightEmission(BlockState var1, BlockGetter var2, BlockPos var3);

    public Predicate<BlockState> maybeHasLightEmission();

    public boolean hasCurrentlyLoadingChunk();

    public LevelChunk getCurrentlyLoadingChunk(GenerationChunkHolder var1);

    public void setCurrentlyLoading(GenerationChunkHolder var1, LevelChunk var2);

    public void chunkFullStatusComplete(LevelChunk var1, ProtoChunk var2);

    public boolean allowAsyncTicketUpdates();

    public void onChunkHolderTicketChange(ServerLevel var1, ChunkHolder var2, int var3, int var4);

    public void chunkUnloadFromWorld(LevelChunk var1);

    public void chunkSyncSave(ServerLevel var1, ChunkAccess var2, SerializableChunkData var3);

    public void onChunkWatch(ServerLevel var1, LevelChunk var2, ServerPlayer var3);

    public void onChunkUnWatch(ServerLevel var1, ChunkPos var2, ServerPlayer var3);

    public void addToGetEntities(Level var1, Entity var2, AABB var3, Predicate<? super Entity> var4, List<Entity> var5);

    public <T extends Entity> void addToGetEntities(Level var1, EntityTypeTest<Entity, T> var2, AABB var3, Predicate<? super T> var4, List<? super T> var5, int var6);

    public void entityMove(Entity var1, long var2, long var4);

    public boolean configFixMC224294();

    public boolean configAutoConfigSendDistance();

    public double configPlayerMaxLoadRate();

    public double configPlayerMaxGenRate();

    public double configPlayerMaxSendRate();

    public int configPlayerMaxConcurrentLoads();

    public int configPlayerMaxConcurrentGens();

    public long configAutoSaveInterval(ServerLevel var1);

    public int configMaxAutoSavePerTick(ServerLevel var1);

    public boolean configFixMC159283();

    public boolean forceNoSave(ChunkAccess var1);

    public CompoundTag convertNBT(DSL.TypeReference var1, DataFixer var2, CompoundTag var3, int var4, int var5);

    public boolean hasMainChunkLoadHook();

    public void mainChunkLoad(ChunkAccess var1, SerializableChunkData var2);

    public List<Entity> modifySavedEntities(ServerLevel var1, int var2, int var3, List<Entity> var4);

    public void unloadEntity(Entity var1);

    public void postLoadProtoChunk(ServerLevel var1, ProtoChunk var2);

    public int modifyEntityTrackingRange(Entity var1, int var2);

    public boolean addTicketForEnderPearls(ServerLevel var1);

    public static final class Holder {
        private static final PlatformHooks INSTANCE = ServiceLoader.load(PlatformHooks.class, PlatformHooks.class.getClassLoader()).findFirst().orElseThrow(() -> new RuntimeException("Failed to locate PlatformHooks"));

        private Holder() {
        }
    }
}

