/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter;

import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.InitialiseHook;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.TypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.collection.CollectionTypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.collection.ListTypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.collection.SortedMapTypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.primitive.BooleanTypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.primitive.ByteTypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.primitive.DoubleTypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.primitive.FloatTypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.primitive.IntegerTypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.primitive.LongTypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.primitive.ShortTypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.primitive.StringTypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.type.BigDecimalTypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.type.BigIntegerTypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.type.DefaultedTypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.type.DurationTypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.annotation.Adaptable;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.annotation.Serializable;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.type.DefaultedValue;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.type.Duration;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class TypeAdapterRegistry {
    private final Map<Class<?>, TypeAdapter<?, ?>> adapters = new HashMap();

    public TypeAdapterRegistry() {
        this.adapters.put(Boolean.TYPE, BooleanTypeAdapter.INSTANCE);
        this.adapters.put(Byte.TYPE, ByteTypeAdapter.INSTANCE);
        this.adapters.put(Short.TYPE, ShortTypeAdapter.INSTANCE);
        this.adapters.put(Integer.TYPE, IntegerTypeAdapter.INSTANCE);
        this.adapters.put(Long.TYPE, LongTypeAdapter.INSTANCE);
        this.adapters.put(Float.TYPE, FloatTypeAdapter.INSTANCE);
        this.adapters.put(Double.TYPE, DoubleTypeAdapter.INSTANCE);
        this.adapters.put(Boolean.class, BooleanTypeAdapter.INSTANCE);
        this.adapters.put(Byte.class, ByteTypeAdapter.INSTANCE);
        this.adapters.put(Short.class, ShortTypeAdapter.INSTANCE);
        this.adapters.put(Integer.class, IntegerTypeAdapter.INSTANCE);
        this.adapters.put(Long.class, LongTypeAdapter.INSTANCE);
        this.adapters.put(Float.class, FloatTypeAdapter.INSTANCE);
        this.adapters.put(Double.class, DoubleTypeAdapter.INSTANCE);
        this.adapters.put(String.class, StringTypeAdapter.INSTANCE);
        this.adapters.put(Collection.class, CollectionTypeAdapter.INSTANCE);
        this.adapters.put(List.class, ListTypeAdapter.INSTANCE);
        this.adapters.put(Map.class, SortedMapTypeAdapter.SORTED_CASE_INSENSITIVE);
        this.adapters.put(LinkedHashMap.class, SortedMapTypeAdapter.SORTED_CASE_INSENSITIVE);
        this.adapters.put(BigInteger.class, BigIntegerTypeAdapter.INSTANCE);
        this.adapters.put(BigDecimal.class, BigDecimalTypeAdapter.INSTANCE);
        this.adapters.put(Duration.class, DurationTypeAdapter.INSTANCE);
        this.adapters.put(DefaultedValue.class, DefaultedTypeAdapter.INSTANCE);
    }

    public TypeAdapter<?, ?> putAdapter(Class<?> clazz, TypeAdapter<?, ?> adapter) {
        return this.adapters.put(clazz, adapter);
    }

    public TypeAdapter<?, ?> getAdapter(Class<?> clazz) {
        return this.adapters.get(clazz);
    }

    public Object deserialize(Object input, Type type) {
        TypeAdapter<?, ?> adapter = null;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            adapter = this.adapters.get(clazz);
        }
        if (adapter == null && type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            adapter = this.adapters.get((Class)parameterizedType.getRawType());
        }
        if (adapter == null) {
            throw new IllegalArgumentException("No adapter for " + String.valueOf(input.getClass()) + " with type " + String.valueOf(type));
        }
        return adapter.deserialize(this, input, type);
    }

    public Object serialize(Object input, Type type) {
        TypeAdapter<?, ?> adapter = null;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            adapter = this.adapters.get(clazz);
        }
        if (adapter == null && type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            adapter = this.adapters.get((Class)parameterizedType.getRawType());
        }
        if (adapter == null) {
            adapter = this.adapters.get(input.getClass());
        }
        if (adapter == null) {
            throw new IllegalArgumentException("No adapter for " + String.valueOf(input.getClass()) + " with type " + String.valueOf(type));
        }
        return adapter.serialize(this, input, type);
    }

    public <T> TypeAdapter<T, Map<Object, Object>> makeAdapter(Class<? extends T> clazz) throws Exception {
        AutoTypeAdapter<? extends T> ret = new AutoTypeAdapter<T>(this, clazz);
        this.putAdapter(clazz, ret);
        return ret;
    }

    public <T> void callInitialisers(T object) {
        TypeAdapter<?, ?> adapter;
        if (object == null) {
            return;
        }
        if (object instanceof InitialiseHook) {
            InitialiseHook initialiseHook = (InitialiseHook)object;
            initialiseHook.initialise();
        }
        if (!((adapter = this.getAdapter(object.getClass())) instanceof AutoTypeAdapter)) {
            return;
        }
        AutoTypeAdapter autoTypeAdapter = (AutoTypeAdapter)adapter;
        autoTypeAdapter.callInitialisers(object);
    }

    private static final class AutoTypeAdapter<T>
    extends TypeAdapter<T, Map<Object, Object>> {
        private final TypeAdapterRegistry registry;
        private final Constructor<? extends T> constructor;
        private final SerializableField[] fields;

        public AutoTypeAdapter(TypeAdapterRegistry registry, Class<? extends T> clazz) throws Exception {
            this.registry = registry;
            this.constructor = clazz.getConstructor(new Class[0]);
            this.fields = AutoTypeAdapter.findSerializableFields(registry, clazz);
        }

        private static TypeAdapter<?, ?> findOrMakeAdapter(TypeAdapterRegistry registry, Class<?> clazz) throws Exception {
            TypeAdapter<?, ?> ret = registry.getAdapter(clazz);
            if (ret != null) {
                return ret;
            }
            for (Annotation annotation : clazz.getAnnotations()) {
                if (!(annotation instanceof Adaptable)) continue;
                Adaptable adaptable = (Adaptable)annotation;
                return registry.makeAdapter(clazz);
            }
            throw new IllegalArgumentException("No type adapter for " + String.valueOf(clazz) + " (Forgot @Adaptable?)");
        }

        private static String makeSerializedKey(String input) {
            StringBuilder ret = new StringBuilder();
            for (char c : input.toCharArray()) {
                if (!Character.isUpperCase(c)) {
                    ret.append(c);
                    continue;
                }
                ret.append('-');
                ret.append(Character.toLowerCase(c));
            }
            return ret.toString();
        }

        private static SerializableField[] findSerializableFields(TypeAdapterRegistry registry, Class<?> clazz) throws Exception {
            ArrayList<SerializableField> ret = new ArrayList<SerializableField>();
            do {
                for (Field field : clazz.getDeclaredFields()) {
                    field.setAccessible(true);
                    for (Annotation annotation : field.getAnnotations()) {
                        if (!(annotation instanceof Serializable)) continue;
                        Serializable serializable = (Serializable)annotation;
                        TypeAdapter adapter = serializable.adapter() != TypeAdapter.class ? serializable.adapter().getConstructor(new Class[0]).newInstance(new Object[0]) : AutoTypeAdapter.findOrMakeAdapter(registry, field.getType());
                        String serializedKey = serializable.serializedKey();
                        if (serializedKey.isEmpty()) {
                            serializedKey = AutoTypeAdapter.makeSerializedKey(field.getName());
                        }
                        ret.add(new SerializableField(field, serializable.required(), serializable.comment(), adapter, serializable.serialize(), serializedKey));
                    }
                }
            } while ((clazz = clazz.getSuperclass()) != Object.class);
            ret.sort((c1, c2) -> c1.serializedKey.compareTo(c2.serializedKey));
            return ret.toArray(new SerializableField[0]);
        }

        @Override
        public T deserialize(TypeAdapterRegistry registry, Object input, Type type) {
            if (!(input instanceof Map)) {
                throw new IllegalArgumentException("Not a map type: " + String.valueOf(input.getClass()));
            }
            Map inputMap = (Map)input;
            try {
                T ret = this.constructor.newInstance(new Object[0]);
                for (SerializableField field : this.fields) {
                    Object fieldValue = inputMap.get(field.serializedKey);
                    if (fieldValue == null) {
                        if (!field.required) continue;
                        throw new IllegalArgumentException("Missing required field '" + field.serializedKey + "' in " + String.valueOf(this.constructor.getDeclaringClass()));
                    }
                    field.field.set(ret, field.adapter.deserialize(registry, fieldValue, field.field.getGenericType()));
                }
                return ret;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public Map<Object, Object> serialize(TypeAdapterRegistry registry, T value, Type type) {
            LinkedHashMap<Object, Object> ret = new LinkedHashMap<Object, Object>();
            for (SerializableField field : this.fields) {
                Object fieldValue;
                if (!field.serialize) continue;
                try {
                    fieldValue = field.field.get(value);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                if (fieldValue == null) continue;
                ret.put(field.comment.isBlank() ? field.serializedKey : new CommentedData(field.comment, field.serializedKey), field.adapter.serialize(registry, fieldValue, field.field.getGenericType()));
            }
            return ret;
        }

        public void callInitialisers(T value) {
            for (SerializableField field : this.fields) {
                Object fieldValue;
                try {
                    fieldValue = field.field.get(value);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                this.registry.callInitialisers(fieldValue);
            }
        }

        private record SerializableField(Field field, boolean required, String comment, TypeAdapter<?, ?> adapter, boolean serialize, String serializedKey) {
        }
    }

    public static final class CommentedData {
        public final String comment;
        public final Object data;

        public CommentedData(String comment, Object data) {
            this.comment = comment;
            this.data = data;
        }
    }
}

