/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.primitive;

import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.TypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.TypeAdapterRegistry;
import java.lang.reflect.Type;
import java.math.BigInteger;

public final class ShortTypeAdapter
extends TypeAdapter<Short, Short> {
    public static final ShortTypeAdapter INSTANCE = new ShortTypeAdapter();

    private static Short cast(Object original, long value) {
        if (value < -32768L || value > 32767L) {
            throw new IllegalArgumentException("Short value is out of range: " + original.toString());
        }
        return (short)value;
    }

    @Override
    public Short deserialize(TypeAdapterRegistry registry, Object input, Type type) {
        if (input instanceof Number) {
            long l;
            Number number = (Number)input;
            if (number instanceof BigInteger) {
                BigInteger bigInteger = (BigInteger)number;
                l = bigInteger.longValueExact();
            } else {
                l = number.longValue();
            }
            return ShortTypeAdapter.cast(input, l);
        }
        if (input instanceof String) {
            String string = (String)input;
            return ShortTypeAdapter.cast(input, (long)Double.parseDouble(string));
        }
        throw new IllegalArgumentException("Not a short type: " + String.valueOf(input.getClass()));
    }

    @Override
    public Short serialize(TypeAdapterRegistry registry, Short value, Type type) {
        return value;
    }
}

