/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.block_entity_remove;

import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemLevel;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Level.class})
abstract class LevelMixin
implements LevelAccessor,
AutoCloseable {
    @Shadow
    protected List<TickingBlockEntity> blockEntityTickers;
    @Shadow
    private List<TickingBlockEntity> pendingBlockEntityTickers;

    LevelMixin() {
    }

    @Shadow
    public abstract TickRateManager tickRateManager();

    @Shadow
    public abstract boolean shouldTickBlocksAt(BlockPos var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void newFieldType(CallbackInfo ci) {
        this.blockEntityTickers = ObjectArrayList.wrap((Object[])new TickingBlockEntity[0]);
        this.pendingBlockEntityTickers = ObjectArrayList.wrap((Object[])new TickingBlockEntity[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"tickBlockEntities"}, at=@At(value="INVOKE", target="Ljava/util/Iterator;hasNext()Z", ordinal=0))
    private boolean newBlockEntityTick(Iterator<TickingBlockEntity> ignored) {
        int i;
        boolean doTick = this.tickRateManager().runsNormally();
        ObjectArrayList tickList = (ObjectArrayList)this.blockEntityTickers;
        TickingBlockEntity[] elements = (TickingBlockEntity[])tickList.elements();
        boolean writeToBase = false;
        int base = 0;
        int len = tickList.size();
        int tickedEntities = 0;
        Objects.checkFromToIndex(0, len, elements.length);
        try {
            for (i = 0; i < len; ++i) {
                TickingBlockEntity tileEntity = elements[i];
                if (tileEntity.isRemoved()) {
                    writeToBase = true;
                    continue;
                }
                if (doTick && this.shouldTickBlocksAt(tileEntity.getPos())) {
                    tileEntity.tick();
                    if ((++tickedEntities & 7) == 0) {
                        ((ChunkSystemLevel)((Level)this)).moonrise$midTickTasks();
                    }
                }
                if (writeToBase) {
                    elements[base] = tileEntity;
                    ++base;
                    continue;
                }
                ++base;
            }
        }
        finally {
            if (i != base) {
                System.arraycopy(elements, i, elements, base, len - i);
                tickList.size(len - (i - base));
            }
        }
        return false;
    }
}

