/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemLevelChunk;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.ticks.ChunkSystemLevelChunkTicks;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.ticks.LevelChunkTicks;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelChunk.class})
abstract class LevelChunkMixin
extends ChunkAccess
implements ChunkSystemLevelChunk {
    @Shadow
    @Final
    private LevelChunkTicks<Block> blockTicks;
    @Shadow
    @Final
    private LevelChunkTicks<Fluid> fluidTicks;
    @Shadow
    @Final
    Level level;
    @Unique
    private boolean postProcessingDone;
    @Unique
    private NewChunkHolder chunkAndHolder;

    public LevelChunkMixin(ChunkPos chunkPos, UpgradeData upgradeData, LevelHeightAccessor levelHeightAccessor, PalettedContainerFactory palettedContainerFactory, long l, @Nullable LevelChunkSection[] levelChunkSections, @Nullable BlendingData blendingData) {
        super(chunkPos, upgradeData, levelHeightAccessor, palettedContainerFactory, l, levelChunkSections, blendingData);
    }

    @Override
    public final boolean moonrise$isPostProcessingDone() {
        return this.postProcessingDone;
    }

    @Override
    public final NewChunkHolder moonrise$getChunkHolder() {
        return this.chunkAndHolder;
    }

    @Override
    public final void moonrise$setChunkHolder(NewChunkHolder holder) {
        this.chunkAndHolder = holder;
    }

    @Inject(method={"postProcessGeneration"}, at={@At(value="RETURN")})
    private void finishPostProcessing(CallbackInfo ci) {
        this.postProcessingDone = true;
    }

    public boolean isUnsaved() {
        long gameTime = this.level.getGameTime();
        if (((ChunkSystemLevelChunkTicks)this.blockTicks).moonrise$isDirty(gameTime) || ((ChunkSystemLevelChunkTicks)this.fluidTicks).moonrise$isDirty(gameTime)) {
            return true;
        }
        return super.isUnsaved();
    }

    public boolean tryMarkSaved() {
        if (!this.isUnsaved()) {
            return false;
        }
        ((ChunkSystemLevelChunkTicks)this.blockTicks).moonrise$clearDirty();
        ((ChunkSystemLevelChunkTicks)this.fluidTicks).moonrise$clearDirty();
        super.tryMarkSaved();
        return true;
    }
}

