/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.common.util.MoonriseCommon;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.server.ChunkSystemMinecraftServer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerInfo;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.server.TickTask;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
abstract class MinecraftServerMixin
extends ReentrantBlockableEventLoop<TickTask>
implements ChunkSystemMinecraftServer,
ServerInfo,
CommandSource,
AutoCloseable {
    @Shadow
    @Final
    private ServerTickRateManager tickRateManager;
    @Shadow
    @Final
    private static Logger LOGGER;
    @Unique
    private volatile Throwable chunkSystemCrash;
    @Unique
    private static final long CHUNK_TASK_QUEUE_BACKOFF_MIN_TIME = 25000L;
    @Unique
    private static final long MAX_CHUNK_EXEC_TIME = 1000L;
    @Unique
    private static final long TASK_EXECUTION_FAILURE_BACKOFF = 5000L;
    @Unique
    private long lastMidTickExecute;
    @Unique
    private long lastMidTickExecuteFailure;

    @Shadow
    public abstract Iterable<ServerLevel> getAllLevels();

    @Shadow
    public abstract boolean saveAllChunks(boolean var1, boolean var2, boolean var3);

    @Shadow
    protected abstract boolean haveTime();

    public MinecraftServerMixin(String string) {
        super(string);
    }

    @Override
    public final void moonrise$setChunkSystemCrash(Throwable throwable) {
        this.chunkSystemCrash = throwable;
    }

    @Unique
    private boolean tickMidTickTasks() {
        boolean executed = false;
        for (ServerLevel world : this.getAllLevels()) {
            long currTime = System.nanoTime();
            if (currTime - ((ChunkSystemServerLevel)world).moonrise$getLastMidTickFailure() <= 5000L) continue;
            if (!world.getChunkSource().pollTask()) {
                ((ChunkSystemServerLevel)world).moonrise$setLastMidTickFailure(currTime);
                continue;
            }
            executed = true;
        }
        return executed;
    }

    @Override
    public final void moonrise$executeMidTickTasks() {
        long overuse;
        long currTime;
        long diff;
        boolean moreTasks;
        long startTime = System.nanoTime();
        if (startTime - this.lastMidTickExecute <= 25000L || startTime - this.lastMidTickExecuteFailure <= 5000L) {
            return;
        }
        do {
            moreTasks = this.tickMidTickTasks();
            currTime = System.nanoTime();
            diff = currTime - startTime;
        } while (moreTasks && diff < 1000L);
        if (!moreTasks) {
            this.lastMidTickExecuteFailure = currTime;
        }
        if ((overuse = diff - 1000L) >= 10000000L) {
            overuse = 10000000L;
        }
        double overuseCount = (double)overuse / 1000.0;
        long extraSleep = Math.round(overuseCount * 25000.0);
        this.lastMidTickExecute = currTime + extraSleep;
    }

    @Overwrite
    private boolean pollTaskInternal() {
        if (super.pollTask()) {
            this.moonrise$executeMidTickTasks();
            return true;
        }
        if (this.tickRateManager.isSprinting() || this.haveTime()) {
            boolean ret = false;
            for (ServerLevel world : this.getAllLevels()) {
                if (!world.getChunkSource().pollTask()) continue;
                ret = true;
            }
            return ret;
        }
        return false;
    }

    @Inject(method={"runServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;tickServer(Ljava/util/function/BooleanSupplier;)V", shift=At.Shift.AFTER)})
    private void hookChunkSystemCrash(CallbackInfo ci) {
        Throwable crash = this.chunkSystemCrash;
        if (crash != null) {
            this.chunkSystemCrash = null;
            throw new RuntimeException("Chunk system crash propagated to tick()", crash);
        }
    }

    @Redirect(method={"stopServer"}, at=@At(value="INVOKE", target="Ljava/util/stream/Stream;anyMatch(Ljava/util/function/Predicate;)Z", ordinal=0))
    private boolean doNotWaitChunkSystemShutdown(Stream<ServerLevel> instance, Predicate<? super ServerLevel> predicate) {
        for (ServerLevel world : this.getAllLevels()) {
            world.getChunkSource().deactivateTicketsOnClosing();
        }
        return false;
    }

    @Redirect(method={"stopServer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;saveAllChunks(ZZZ)Z"))
    private boolean markClosed(MinecraftServer instance, boolean bl, boolean bl2, boolean bl3) {
        for (ServerLevel world : this.getAllLevels()) {
            ((ChunkSystemServerLevel)world).moonrise$setMarkedClosing(true);
        }
        return this.saveAllChunks(false, true, true);
    }

    @Redirect(method={"stopServer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;close()V", ordinal=0))
    private void noOpClose(ServerLevel instance) {
    }

    @Inject(method={"stopServer"}, at={@At(value="RETURN")})
    private void closeIOThreads(CallbackInfo ci) {
        LOGGER.info("Waiting for all RegionFile I/O tasks to complete...");
        MoonriseRegionFileIO.flush((MinecraftServer)this);
        LOGGER.info("All RegionFile I/O tasks to complete");
        if (this instanceof DedicatedServer) {
            MoonriseCommon.haltExecutors();
        }
    }
}

