/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.patches.chunk_system.MoonriseChunkLoadCounter;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.server.level.ChunkLoadCounter;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.network.config.PrepareSpawnTask;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={PrepareSpawnTask.Preparing.class})
abstract class PrepareSpawnTaskPreparingMixin {
    @Shadow
    @Nullable
    private CompletableFuture<?> chunkLoadFuture;

    PrepareSpawnTaskPreparingMixin() {
    }

    @Redirect(method={"<init>"}, at=@At(value="NEW", target="()Lnet/minecraft/server/level/ChunkLoadCounter;"))
    private ChunkLoadCounter replaceChunkLoadCounter() {
        return new MoonriseChunkLoadCounter();
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkLoadCounter;track(Lnet/minecraft/server/level/ServerLevel;Ljava/lang/Runnable;)V"))
    private void redirectTrack(ChunkLoadCounter instance, ServerLevel level, Runnable task, @Local ChunkPos chunkPos) {
        CompletableFuture<?> future = ((MoonriseChunkLoadCounter)instance).trackLoadWithRadius(level, chunkPos, 3, ChunkStatus.FULL, Priority.HIGH, () -> level.getChunkSource().addTicketWithRadius(TicketType.PLAYER_SPAWN, chunkPos, 3));
        this.chunkLoadFuture = future;
    }
}

