/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.patches.chunk_system.util.ChunkSystemSortedArraySet;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Predicate;
import net.minecraft.util.SortedArraySet;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={SortedArraySet.class})
abstract class SortedArraySetMixin<T>
extends AbstractSet<T>
implements ChunkSystemSortedArraySet<T> {
    @Shadow
    int size;
    @Shadow
    T[] contents;
    @Shadow
    @Final
    private Comparator<T> comparator;

    SortedArraySetMixin() {
    }

    @Shadow
    protected abstract int findIndex(T var1);

    @Shadow
    private static int getInsertionPosition(int i) {
        return 0;
    }

    @Shadow
    protected abstract void addInternal(T var1, int var2);

    @Shadow
    abstract void removeInternal(int var1);

    @Override
    public final boolean removeIf(Predicate<? super T> filter) {
        int i = 0;
        int len = this.size;
        Object[] backingArray = this.contents;
        do {
            if (i < len) continue;
            return false;
        } while (!filter.test(backingArray[i++]));
        int lastIndex = i - 1;
        while (i < len) {
            T curr = backingArray[i];
            if (!filter.test(curr)) {
                backingArray[lastIndex++] = curr;
            }
            ++i;
        }
        Arrays.fill(backingArray, lastIndex, len, null);
        this.size = lastIndex;
        return true;
    }

    @Override
    public final T moonrise$replace(T object) {
        int index = this.findIndex(object);
        if (index >= 0) {
            T old = this.contents[index];
            this.contents[index] = object;
            return old;
        }
        this.addInternal(object, SortedArraySetMixin.getInsertionPosition(index));
        return object;
    }

    @Override
    public final T moonrise$removeAndGet(T object) {
        int i = this.findIndex(object);
        if (i >= 0) {
            T ret = this.contents[i];
            this.removeInternal(i);
            return ret;
        }
        return null;
    }

    @Override
    public final SortedArraySet<T> moonrise$copy() {
        SortedArraySet ret = SortedArraySet.create(this.comparator, (int)0);
        ((SortedArraySetMixin)ret).size = this.size;
        ((SortedArraySetMixin)ret).contents = Arrays.copyOf(this.contents, this.size);
        return ret;
    }

    @Override
    public Object[] moonrise$copyBackingArray() {
        return (Object[])this.contents.clone();
    }
}

