/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.tick_loop;

import ca.spottedleaf.moonrise.patches.tick_loop.TickLoopPacketProcessor;
import java.util.Queue;
import java.util.concurrent.locks.LockSupport;
import net.minecraft.network.PacketProcessor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={PacketProcessor.class})
abstract class PacketProcessorMixin
implements AutoCloseable,
TickLoopPacketProcessor {
    @Shadow
    private boolean closed;
    @Shadow
    @Final
    private Queue<PacketProcessor.ListenerAndPacket<?>> packetsToBeHandled;
    @Shadow
    @Final
    private Thread runningThread;

    PacketProcessorMixin() {
    }

    @Override
    public final boolean moonrise$executeSinglePacket() {
        if (this.closed) {
            return false;
        }
        PacketProcessor.ListenerAndPacket<?> task = this.packetsToBeHandled.poll();
        if (task == null) {
            return false;
        }
        task.handle();
        return true;
    }

    @Redirect(method={"scheduleIfPossible"}, at=@At(value="INVOKE", target="Ljava/util/Queue;add(Ljava/lang/Object;)Z"))
    private <E> boolean unparkWaitingThread(Queue<E> instance, E element) {
        boolean isEmpty = instance.isEmpty();
        boolean ret = instance.add(element);
        if (isEmpty || instance.peek() == element) {
            LockSupport.unpark(this.runningThread);
        }
        return ret;
    }
}

