/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.neoforge.mixin.collisions;

import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.neoforge.patches.collisions.FluidPushCalculation;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.extensions.IEntityExtension;
import net.neoforged.neoforge.fluids.FluidType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Entity.class})
abstract class EntityMixin
implements IEntityExtension {
    @Shadow
    private Level level;

    EntityMixin() {
    }

    @Shadow
    public abstract boolean touchingUnloadedChunk();

    @Shadow
    public abstract AABB getBoundingBox();

    @Shadow
    protected abstract void setFluidTypeHeight(FluidType var1, double var2);

    @Shadow
    public abstract Vec3 getDeltaMovement();

    @Shadow
    public abstract void setDeltaMovement(Vec3 var1);

    @Overwrite
    public void updateFluidHeightAndDoFluidPushing() {
        if (this.touchingUnloadedChunk()) {
            return;
        }
        AABB boundingBox = this.getBoundingBox().deflate(0.001);
        Level world = this.level;
        int minSection = WorldUtil.getMinSection(world);
        int minBlockX = Mth.floor((double)boundingBox.minX);
        int minBlockY = Math.max(minSection << 4, Mth.floor((double)boundingBox.minY));
        int minBlockZ = Mth.floor((double)boundingBox.minZ);
        int maxBlockX = Mth.ceil((double)boundingBox.maxX) - 1;
        int maxBlockY = Math.min(WorldUtil.getMaxSection(world) << 4 | 0xF, Mth.ceil((double)boundingBox.maxY) - 1);
        int maxBlockZ = Mth.ceil((double)boundingBox.maxZ) - 1;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int maxChunkY = maxBlockY >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        ChunkSource chunkSource = world.getChunkSource();
        Reference2ReferenceArrayMap calculations = new Reference2ReferenceArrayMap();
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                LevelChunkSection[] sections = chunkSource.getChunk(currChunkX, currChunkZ, ChunkStatus.FULL, false).getSections();
                for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                    LevelChunkSection section;
                    int sectionIdx = currChunkY - minSection;
                    if (sectionIdx < 0 || sectionIdx >= sections.length || (section = sections[sectionIdx]).hasOnlyAir()) continue;
                    PalettedContainer blocks = section.states;
                    int minXIterate = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                    int maxXIterate = currChunkX == maxChunkX ? maxBlockX & 0xF : 15;
                    int minZIterate = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
                    int maxZIterate = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 15;
                    int minYIterate = currChunkY == minChunkY ? minBlockY & 0xF : 0;
                    int maxYIterate = currChunkY == maxChunkY ? maxBlockY & 0xF : 15;
                    for (int currY = minYIterate; currY <= maxYIterate; ++currY) {
                        for (int currZ = minZIterate; currZ <= maxZIterate; ++currZ) {
                            for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                FluidState fluidState = ((BlockState)blocks.get(currX | currZ << 4 | currY << 8)).getFluidState();
                                if (fluidState.isEmpty()) continue;
                                mutablePos.set(currX | currChunkX << 4, currY | currChunkY << 4, currZ | currChunkZ << 4);
                                FluidType type = fluidState.getFluidType();
                                FluidPushCalculation calculation = (FluidPushCalculation)calculations.computeIfAbsent((Object)type, key -> new FluidPushCalculation());
                                double height = (float)mutablePos.getY() + fluidState.getHeight((BlockGetter)world, (BlockPos)mutablePos);
                                double diff = height - boundingBox.minY;
                                if (diff < 0.0) continue;
                                calculation.maxHeightDiff = Math.max(calculation.maxHeightDiff, diff);
                                if (calculation.isPushed == Boolean.FALSE) continue;
                                if (calculation.isPushed == null) {
                                    boolean isPushed = this.isPushedByFluid(type);
                                    calculation.isPushed = isPushed;
                                    if (!isPushed) continue;
                                }
                                calculation.totalPushes += 1.0;
                                Vec3 flow = fluidState.getFlow((BlockGetter)world, (BlockPos)mutablePos);
                                calculation.pushVector = diff < 0.4 ? calculation.pushVector.add(flow.scale(diff)) : calculation.pushVector.add(flow);
                            }
                        }
                    }
                }
            }
        }
        if (calculations.isEmpty()) {
            return;
        }
        ObjectIterator iterator = calculations.reference2ReferenceEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Reference2ReferenceMap.Entry entry = (Reference2ReferenceMap.Entry)iterator.next();
            FluidType type = (FluidType)entry.getKey();
            FluidPushCalculation calculation = (FluidPushCalculation)entry.getValue();
            this.setFluidTypeHeight(type, calculation.maxHeightDiff);
            Vec3 pushVector = calculation.pushVector;
            if (pushVector.lengthSqr() == 0.0) continue;
            pushVector = pushVector.scale(1.0 / calculation.totalPushes);
            Vec3 currMovement = this.getDeltaMovement();
            if (!((Entity)this instanceof Player)) {
                pushVector = pushVector.normalize();
            }
            pushVector = pushVector.scale(this.getFluidMotionScale(type));
            if (Math.abs(currMovement.x) < 0.003 && Math.abs(currMovement.z) < 0.003 && pushVector.length() < 0.0045000000000000005) {
                pushVector = pushVector.normalize().scale(0.0045000000000000005);
            }
            this.setDeltaMovement(currMovement.add(pushVector));
        }
    }
}

