/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.util;

import ca.spottedleaf.moonrise.common.util.ChunkSystemHooks;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemLevelChunk;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import ca.spottedleaf.moonrise.patches.chunk_system.world.ChunkSystemServerChunkCache;
import ca.spottedleaf.moonrise.patches.chunk_tick_iteration.ChunkTickServerLevel;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3193;
import net.minecraft.class_3194;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public abstract class BaseChunkSystemHooks
implements ChunkSystemHooks {
    @Override
    public void scheduleChunkTask(class_3218 level, int chunkX, int chunkZ, Runnable run) {
        this.scheduleChunkTask(level, chunkX, chunkZ, run, Priority.NORMAL);
    }

    @Override
    public void scheduleChunkTask(class_3218 level, int chunkX, int chunkZ, Runnable run, Priority priority) {
        ((ChunkSystemServerLevel)level).moonrise$getChunkTaskScheduler().scheduleChunkTask(chunkX, chunkZ, run, priority);
    }

    @Override
    public void scheduleChunkLoad(class_3218 level, int chunkX, int chunkZ, boolean gen, class_2806 toStatus, boolean addTicket, Priority priority, Consumer<class_2791> onComplete) {
        ((ChunkSystemServerLevel)level).moonrise$getChunkTaskScheduler().scheduleChunkLoad(chunkX, chunkZ, gen, toStatus, addTicket, priority, onComplete);
    }

    @Override
    public void scheduleChunkLoad(class_3218 level, int chunkX, int chunkZ, class_2806 toStatus, boolean addTicket, Priority priority, Consumer<class_2791> onComplete) {
        ((ChunkSystemServerLevel)level).moonrise$getChunkTaskScheduler().scheduleChunkLoad(chunkX, chunkZ, toStatus, addTicket, priority, onComplete);
    }

    @Override
    public void scheduleTickingState(class_3218 level, int chunkX, int chunkZ, class_3194 toStatus, boolean addTicket, Priority priority, Consumer<class_2818> onComplete) {
        ((ChunkSystemServerLevel)level).moonrise$getChunkTaskScheduler().scheduleTickingState(chunkX, chunkZ, toStatus, addTicket, priority, onComplete);
    }

    @Override
    public List<class_3193> getVisibleChunkHolders(class_3218 level) {
        return ((ChunkSystemServerLevel)level).moonrise$getChunkTaskScheduler().chunkHolderManager.getOldChunkHolders();
    }

    @Override
    public List<class_3193> getUpdatingChunkHolders(class_3218 level) {
        return ((ChunkSystemServerLevel)level).moonrise$getChunkTaskScheduler().chunkHolderManager.getOldChunkHolders();
    }

    @Override
    public int getVisibleChunkHolderCount(class_3218 level) {
        return ((ChunkSystemServerLevel)level).moonrise$getChunkTaskScheduler().chunkHolderManager.size();
    }

    @Override
    public int getUpdatingChunkHolderCount(class_3218 level) {
        return ((ChunkSystemServerLevel)level).moonrise$getChunkTaskScheduler().chunkHolderManager.size();
    }

    @Override
    public boolean hasAnyChunkHolders(class_3218 level) {
        return this.getUpdatingChunkHolderCount(level) != 0;
    }

    @Override
    public void onChunkHolderCreate(class_3218 level, class_3193 holder) {
    }

    @Override
    public void onChunkHolderDelete(class_3218 level, class_3193 holder) {
    }

    @Override
    public void onChunkPreBorder(class_2818 chunk, class_3193 holder) {
        ((ChunkSystemServerChunkCache)((class_3218)chunk.method_12200()).method_14178()).moonrise$setFullChunk(chunk.method_12004().field_9181, chunk.method_12004().field_9180, chunk);
    }

    @Override
    public void onChunkBorder(class_2818 chunk, class_3193 holder) {
        ((ChunkSystemServerLevel)((class_3218)chunk.method_12200())).moonrise$getLoadedChunks().add(chunk);
    }

    @Override
    public void onChunkNotBorder(class_2818 chunk, class_3193 holder) {
        ((ChunkSystemServerLevel)((class_3218)chunk.method_12200())).moonrise$getLoadedChunks().remove(chunk);
    }

    @Override
    public void onChunkPostNotBorder(class_2818 chunk, class_3193 holder) {
        ((ChunkSystemServerChunkCache)((class_3218)chunk.method_12200()).method_14178()).moonrise$setFullChunk(chunk.method_12004().field_9181, chunk.method_12004().field_9180, null);
    }

    @Override
    public void onChunkTicking(class_2818 chunk, class_3193 holder) {
        ((ChunkSystemServerLevel)((class_3218)chunk.method_12200())).moonrise$getTickingChunks().add(chunk);
        if (!((ChunkSystemLevelChunk)chunk).moonrise$isPostProcessingDone()) {
            chunk.method_12221((class_3218)chunk.method_12200());
        }
        ((class_3218)chunk.method_12200()).method_39223(chunk);
    }

    @Override
    public void onChunkNotTicking(class_2818 chunk, class_3193 holder) {
        ((ChunkSystemServerLevel)((class_3218)chunk.method_12200())).moonrise$getTickingChunks().remove(chunk);
    }

    @Override
    public void onChunkEntityTicking(class_2818 chunk, class_3193 holder) {
        ((ChunkSystemServerLevel)((class_3218)chunk.method_12200())).moonrise$getEntityTickingChunks().add(chunk);
        ((ChunkTickServerLevel)((class_3218)chunk.method_12200())).moonrise$markChunkForPlayerTicking(chunk);
    }

    @Override
    public void onChunkNotEntityTicking(class_2818 chunk, class_3193 holder) {
        ((ChunkSystemServerLevel)((class_3218)chunk.method_12200())).moonrise$getEntityTickingChunks().remove(chunk);
        ((ChunkTickServerLevel)((class_3218)chunk.method_12200())).moonrise$removeChunkForPlayerTicking(chunk);
    }

    @Override
    public class_3193 getUnloadingChunkHolder(class_3218 level, int chunkX, int chunkZ) {
        return null;
    }

    @Override
    public int getSendViewDistance(class_3222 player) {
        return RegionizedPlayerChunkLoader.getAPISendViewDistance(player);
    }

    @Override
    public int getViewDistance(class_3222 player) {
        return RegionizedPlayerChunkLoader.getAPIViewDistance(player);
    }

    @Override
    public int getTickViewDistance(class_3222 player) {
        return RegionizedPlayerChunkLoader.getAPITickViewDistance(player);
    }

    @Override
    public void addPlayerToDistanceMaps(class_3218 world, class_3222 player) {
        ((ChunkSystemServerLevel)world).moonrise$getPlayerChunkLoader().addPlayer(player);
    }

    @Override
    public void removePlayerFromDistanceMaps(class_3218 world, class_3222 player) {
        ((ChunkSystemServerLevel)world).moonrise$getPlayerChunkLoader().removePlayer(player);
    }

    @Override
    public void updateMaps(class_3218 world, class_3222 player) {
        ((ChunkSystemServerLevel)world).moonrise$getPlayerChunkLoader().updatePlayer(player);
    }
}

