/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.util;

import ca.spottedleaf.moonrise.common.util.EntityUtil;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TickThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(TickThread.class);
    public final int id;
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger();

    private static String getThreadContext() {
        return "thread=" + Thread.currentThread().getName();
    }

    @Deprecated
    public static void ensureTickThread(String reason) {
        if (!TickThread.isTickThread()) {
            LOGGER.error("Thread failed main thread check: " + reason + ", context=" + TickThread.getThreadContext(), new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(class_1937 world, class_2338 pos, String reason) {
        if (!TickThread.isTickThreadFor(world, pos)) {
            String ex = "Thread failed main thread check: " + reason + ", context=" + TickThread.getThreadContext() + ", world=" + WorldUtil.getWorldName(world) + ", block_pos=" + String.valueOf(pos);
            LOGGER.error(ex, new Throwable());
            throw new IllegalStateException(ex);
        }
    }

    public static void ensureTickThread(class_1937 world, class_2338 pos, int blockRadius, String reason) {
        if (!TickThread.isTickThreadFor(world, pos, blockRadius)) {
            String ex = "Thread failed main thread check: " + reason + ", context=" + TickThread.getThreadContext() + ", world=" + WorldUtil.getWorldName(world) + ", block_pos=" + String.valueOf(pos) + ", block_radius=" + blockRadius;
            LOGGER.error(ex, new Throwable());
            throw new IllegalStateException(ex);
        }
    }

    public static void ensureTickThread(class_1937 world, class_1923 pos, String reason) {
        if (!TickThread.isTickThreadFor(world, pos)) {
            String ex = "Thread failed main thread check: " + reason + ", context=" + TickThread.getThreadContext() + ", world=" + WorldUtil.getWorldName(world) + ", chunk_pos=" + String.valueOf(pos);
            LOGGER.error(ex, new Throwable());
            throw new IllegalStateException(ex);
        }
    }

    public static void ensureTickThread(class_1937 world, int chunkX, int chunkZ, String reason) {
        if (!TickThread.isTickThreadFor(world, chunkX, chunkZ)) {
            String ex = "Thread failed main thread check: " + reason + ", context=" + TickThread.getThreadContext() + ", world=" + WorldUtil.getWorldName(world) + ", chunk_pos=" + String.valueOf(new class_1923(chunkX, chunkZ));
            LOGGER.error(ex, new Throwable());
            throw new IllegalStateException(ex);
        }
    }

    public static void ensureTickThread(class_1297 entity, String reason) {
        if (!TickThread.isTickThreadFor(entity)) {
            String ex = "Thread failed main thread check: " + reason + ", context=" + TickThread.getThreadContext() + ", entity=" + EntityUtil.dumpEntity(entity);
            LOGGER.error(ex, new Throwable());
            throw new IllegalStateException(ex);
        }
    }

    public static void ensureTickThread(class_1937 world, class_238 aabb, String reason) {
        if (!TickThread.isTickThreadFor(world, aabb)) {
            String ex = "Thread failed main thread check: " + reason + ", context=" + TickThread.getThreadContext() + ", world=" + WorldUtil.getWorldName(world) + ", aabb=" + String.valueOf(aabb);
            LOGGER.error(ex, new Throwable());
            throw new IllegalStateException(ex);
        }
    }

    public static void ensureTickThread(class_1937 world, double blockX, double blockZ, String reason) {
        if (!TickThread.isTickThreadFor(world, blockX, blockZ)) {
            String ex = "Thread failed main thread check: " + reason + ", context=" + TickThread.getThreadContext() + ", world=" + WorldUtil.getWorldName(world) + ", block_pos=" + String.valueOf(new class_243(blockX, 0.0, blockZ));
            LOGGER.error(ex, new Throwable());
            throw new IllegalStateException(ex);
        }
    }

    public TickThread(String name) {
        this((Runnable)null, name);
    }

    public TickThread(Runnable run, String name) {
        this(null, run, name);
    }

    public TickThread(ThreadGroup group, Runnable run, String name) {
        this(group, run, name, ID_GENERATOR.incrementAndGet());
    }

    private TickThread(ThreadGroup group, Runnable run, String name, int id) {
        super(group, run, name);
        this.id = id;
    }

    public static TickThread getCurrentTickThread() {
        return (TickThread)Thread.currentThread();
    }

    public static boolean isTickThread() {
        return Thread.currentThread() instanceof TickThread;
    }

    public static boolean isShutdownThread() {
        return false;
    }

    public static boolean isTickThreadFor(class_1937 world, class_2338 pos) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(class_1937 world, class_2338 pos, int blockRadius) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(class_1937 world, class_1923 pos) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(class_1937 world, class_243 pos) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(class_1937 world, int chunkX, int chunkZ) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(class_1937 world, class_238 aabb) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(class_1937 world, double blockX, double blockZ) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(class_1937 world, class_243 position, class_243 deltaMovement, int buffer) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(class_1937 world, int fromChunkX, int fromChunkZ, int toChunkX, int toChunkZ) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(class_1937 world, int chunkX, int chunkZ, int radius) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(class_1297 entity) {
        return TickThread.isTickThread();
    }
}

