/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_3193;
import net.minecraft.class_3194;
import net.minecraft.class_3222;
import net.minecraft.class_3898;
import net.minecraft.class_9259;
import net.minecraft.class_9761;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3193.class})
abstract class ChunkHolderMixin
extends class_9761
implements ChunkSystemChunkHolder {
    @Shadow
    @Final
    private class_3193.class_3897 field_17210;
    @Shadow
    private volatile CompletableFuture<class_9259<class_2818>> field_16431;
    @Shadow
    private volatile CompletableFuture<class_9259<class_2818>> field_19333;
    @Shadow
    private volatile CompletableFuture<class_9259<class_2818>> field_13865;
    @Shadow
    private CompletableFuture<?> field_26930;
    @Shadow
    private CompletableFuture<?> field_46085;
    @Shadow
    private CompletableFuture<?> field_51858;
    @Unique
    private NewChunkHolder newChunkHolder;
    @Unique
    private final ReferenceList<class_3222> playersSentChunkTo = new ReferenceList<class_3222>(EMPTY_PLAYER_ARRAY);
    @Unique
    private static final class_3222[] EMPTY_PLAYER_ARRAY = new class_3222[0];

    public ChunkHolderMixin(class_1923 chunkPos) {
        super(chunkPos);
    }

    @Unique
    private class_3898 getChunkMap() {
        return (class_3898)this.field_17210;
    }

    @Override
    public final NewChunkHolder moonrise$getRealChunkHolder() {
        return this.newChunkHolder;
    }

    @Override
    public final void moonrise$setRealChunkHolder(NewChunkHolder newChunkHolder) {
        this.newChunkHolder = newChunkHolder;
    }

    @Override
    public final void moonrise$addReceivedChunk(class_3222 player) {
        if (!this.playersSentChunkTo.add(player)) {
            throw new IllegalStateException("Already sent chunk " + String.valueOf(this.field_51868) + " in world '" + WorldUtil.getWorldName((class_1937)this.getChunkMap().field_17214) + "' to player " + String.valueOf(player));
        }
    }

    @Override
    public final void moonrise$removeReceivedChunk(class_3222 player) {
        if (!this.playersSentChunkTo.remove(player)) {
            throw new IllegalStateException("Already sent chunk " + String.valueOf(this.field_51868) + " in world '" + WorldUtil.getWorldName((class_1937)this.getChunkMap().field_17214) + "' to player " + String.valueOf(player));
        }
    }

    @Override
    public final boolean moonrise$hasChunkBeenSent() {
        return this.playersSentChunkTo.size() != 0;
    }

    @Override
    public final boolean moonrise$hasChunkBeenSent(class_3222 to) {
        return this.playersSentChunkTo.contains(to);
    }

    @Override
    public final List<class_3222> moonrise$getPlayers(boolean onlyOnWatchDistanceEdge) {
        ArrayList<class_3222> ret = new ArrayList<class_3222>();
        class_3222[] raw = this.playersSentChunkTo.getRawDataUnchecked();
        int len = this.playersSentChunkTo.size();
        for (int i = 0; i < len; ++i) {
            class_3222 player = raw[i];
            if (onlyOnWatchDistanceEdge && !((ChunkSystemServerLevel)this.getChunkMap().field_17214).moonrise$getPlayerChunkLoader().isChunkSent(player, this.field_51868.field_9181, this.field_51868.field_9180, onlyOnWatchDistanceEdge)) continue;
            ret.add(player);
        }
        return ret;
    }

    @Inject(method={"<init>(Lnet/minecraft/class_1923;ILnet/minecraft/class_5539;Lnet/minecraft/class_3568;Lnet/minecraft/class_3193$class_3896;Lnet/minecraft/class_3193$class_3897;)V"}, at={@At(value="RETURN")})
    private void initFields(CallbackInfo ci) {
        this.field_16431 = null;
        this.field_19333 = null;
        this.field_13865 = null;
        this.field_26930 = null;
        this.field_46085 = null;
        this.field_51858 = null;
    }

    @Overwrite
    public CompletableFuture<class_9259<class_2791>> method_16145() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public CompletableFuture<class_9259<class_2791>> method_14003() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public CompletableFuture<class_9259<class_2791>> method_20725() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public class_2818 method_16144() {
        class_2791 class_27912;
        if (this.newChunkHolder.isTickingReady() && (class_27912 = this.newChunkHolder.getCurrentChunk()) instanceof class_2818) {
            class_2818 levelChunk = (class_2818)class_27912;
            return levelChunk;
        }
        return null;
    }

    @Overwrite
    public CompletableFuture<?> method_53681() {
        throw new UnsupportedOperationException();
    }

    @Unique
    private boolean isRadiusLoaded(int radius) {
        ChunkHolderManager manager = ((ChunkSystemServerLevel)this.getChunkMap().field_17214).moonrise$getChunkTaskScheduler().chunkHolderManager;
        class_1923 pos = this.field_51868;
        int chunkX = pos.field_9181;
        int chunkZ = pos.field_9180;
        for (int dz = -radius; dz <= radius; ++dz) {
            for (int dx = -radius; dx <= radius; ++dx) {
                NewChunkHolder holder;
                if ((dx | dz) == 0 || (holder = manager.getChunkHolder(dx + chunkX, dz + chunkZ)) != null && holder.isFullChunkReady()) continue;
                return false;
            }
        }
        return true;
    }

    @Overwrite
    public class_2818 method_53682() {
        class_2818 ret = this.moonrise$getFullChunk();
        if (ret != null && this.isRadiusLoaded(1)) {
            return ret;
        }
        return null;
    }

    @Override
    public final class_2818 moonrise$getFullChunk() {
        class_2791 class_27912;
        if (this.newChunkHolder.isFullChunkReady() && (class_27912 = this.newChunkHolder.getCurrentChunk()) instanceof class_2818) {
            class_2818 levelChunk = (class_2818)class_27912;
            return levelChunk;
        }
        return null;
    }

    @Overwrite
    public CompletableFuture<class_2791> method_14000() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public boolean method_60436() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void method_39967(CompletableFuture<?> completableFuture) {
        throw new UnsupportedOperationException();
    }

    @Redirect(method={"method_14002(Lnet/minecraft/class_2338;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3193;method_16144()Lnet/minecraft/class_2818;"))
    private class_2818 redirectBlockUpdate(class_3193 instance) {
        if (this.playersSentChunkTo.size() == 0) {
            return null;
        }
        return this.method_53682();
    }

    @Redirect(method={"method_14012(Lnet/minecraft/class_1944;I)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3193;method_16144()Lnet/minecraft/class_2818;"))
    private class_2818 redirectLightUpdate(class_3193 instance) {
        if (this.playersSentChunkTo.size() == 0) {
            return null;
        }
        return this.method_53682();
    }

    @Redirect(method={"method_14006(Lnet/minecraft/class_2818;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_3193$class_3897;method_17210(Lnet/minecraft/class_1923;Z)Ljava/util/List;"))
    private List<class_3222> redirectPlayerRetrieval(class_3193.class_3897 instance, class_1923 chunkPos, boolean onlyOnWatchDistanceEdge) {
        return this.moonrise$getPlayers(onlyOnWatchDistanceEdge);
    }

    @Overwrite
    public void method_53680(CompletableFuture<?> completableFuture) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public int method_14005() {
        return this.newChunkHolder.getTicketLevel();
    }

    @Overwrite
    public int method_17208() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void method_17207(int i) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void method_15890(int i) {
    }

    @Overwrite
    public void method_31409(class_3898 chunkMap, CompletableFuture<class_9259<class_2818>> completableFuture, Executor executor, class_3194 fullChunkStatus) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void method_31408(class_3898 chunkMap, class_3194 fullChunkStatus) {
        throw new UnsupportedOperationException();
    }

    @Inject(method={"method_14007(Lnet/minecraft/class_3898;Ljava/util/concurrent/Executor;)V"}, at={@At(value="HEAD")})
    public void clobberUpdateFutures(class_3898 chunkMap, Executor executor, CallbackInfo ci) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public boolean method_20384() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void method_20385() {
        throw new UnsupportedOperationException();
    }
}

