/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.util;

import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.IntegerUtil;
import ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.PropertyAccess;
import ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.PropertyAccessStateHolder;
import ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.util.ZeroCollidingReferenceStateTable;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.AbstractReference2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_2688;
import net.minecraft.class_2769;

public final class ZeroCollidingReferenceStateTable<O, S> {
    private final Int2ObjectOpenHashMap<Indexer> propertyToIndexer;
    private S[] lookup;
    private final Collection<class_2769<?>> properties;

    public ZeroCollidingReferenceStateTable(Collection<class_2769<?>> properties) {
        this.propertyToIndexer = new Int2ObjectOpenHashMap(properties.size());
        this.properties = new ReferenceArrayList(properties);
        ArrayList sortedProperties = new ArrayList(properties);
        sortedProperties.sort((p1, p2) -> Integer.compare(((PropertyAccess)p1).moonrise$getId(), ((PropertyAccess)p2).moonrise$getId()));
        int currentMultiple = 1;
        for (class_2769 class_27692 : sortedProperties) {
            int totalValues = class_27692.method_11898().size();
            this.propertyToIndexer.put(((PropertyAccess)class_27692).moonrise$getId(), (Object)new Indexer(totalValues, currentMultiple, IntegerUtil.getUnsignedDivisorMagic(currentMultiple, 32), IntegerUtil.getUnsignedDivisorMagic(totalValues, 32)));
            currentMultiple *= totalValues;
        }
    }

    public <T extends Comparable<T>> boolean hasProperty(class_2769<T> property) {
        return this.propertyToIndexer.containsKey(((PropertyAccess)property).moonrise$getId());
    }

    public long getIndex(class_2688<O, S> stateHolder) {
        long ret = 0L;
        for (Map.Entry entry : stateHolder.method_11656().entrySet()) {
            class_2769 property = (class_2769)entry.getKey();
            Comparable value = (Comparable)entry.getValue();
            Indexer indexer = (Indexer)this.propertyToIndexer.get(((PropertyAccess)property).moonrise$getId());
            ret += (long)(((PropertyAccess)property).moonrise$getIdFor(value) * indexer.multiple);
        }
        return ret;
    }

    public boolean isLoaded() {
        return this.lookup != null;
    }

    public void loadInTable(Map<Map<class_2769<?>, Comparable<?>>, S> universe) {
        if (this.lookup != null) {
            throw new IllegalStateException();
        }
        this.lookup = new class_2688[universe.size()];
        for (Map.Entry<Map<class_2769<?>, Comparable<?>>, S> entry : universe.entrySet()) {
            S value = entry.getValue();
            if (value == null) continue;
            this.lookup[(int)((PropertyAccessStateHolder)((class_2688)value)).moonrise$getTableIndex()] = value;
        }
        for (S value : this.lookup) {
            if (value != null) continue;
            throw new IllegalStateException();
        }
    }

    public <T extends Comparable<T>> T get(long index, class_2769<T> property) {
        Indexer indexer = (Indexer)this.propertyToIndexer.get(((PropertyAccess)property).moonrise$getId());
        if (indexer == null) {
            return null;
        }
        long divided = index * indexer.multipleDivMagic >>> 32;
        long modded = (divided * indexer.modMagic & 0xFFFFFFFFL) * (long)indexer.totalValues >>> 32;
        return (T)((Comparable)((PropertyAccess)property).moonrise$getById((int)modded));
    }

    public <T extends Comparable<T>> S set(long index, class_2769<T> property, T with) {
        int newValueId = ((PropertyAccess)property).moonrise$getIdFor(with);
        if (newValueId < 0) {
            return null;
        }
        Indexer indexer = (Indexer)this.propertyToIndexer.get(((PropertyAccess)property).moonrise$getId());
        if (indexer == null) {
            return null;
        }
        long divided = index * indexer.multipleDivMagic >>> 32;
        long modded = (divided * indexer.modMagic & 0xFFFFFFFFL) * (long)indexer.totalValues >>> 32;
        long newIndex = ((long)newValueId - modded) * (long)indexer.multiple + index;
        return this.lookup[(int)newIndex];
    }

    public <T extends Comparable<T>> S trySet(long index, class_2769<T> property, T with, S dfl) {
        Indexer indexer = (Indexer)this.propertyToIndexer.get(((PropertyAccess)property).moonrise$getId());
        if (indexer == null) {
            return dfl;
        }
        int newValueId = ((PropertyAccess)property).moonrise$getIdFor(with);
        if (newValueId < 0) {
            return null;
        }
        long divided = index * indexer.multipleDivMagic >>> 32;
        long modded = (divided * indexer.modMagic & 0xFFFFFFFFL) * (long)indexer.totalValues >>> 32;
        long newIndex = ((long)newValueId - modded) * (long)indexer.multiple + index;
        return this.lookup[(int)newIndex];
    }

    public Collection<class_2769<?>> getProperties() {
        return Collections.unmodifiableCollection(this.properties);
    }

    public Map<class_2769<?>, Comparable<?>> getMapView(long stateIndex) {
        return new MapView(stateIndex);
    }

    private record Indexer(int totalValues, int multiple, long multipleDivMagic, long modMagic) {
    }

    private class MapView
    extends AbstractReference2ObjectMap<class_2769<?>, Comparable<?>> {
        private final long stateIndex;
        private ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.util.ZeroCollidingReferenceStateTable$MapView.EntrySet entrySet;

        MapView(long stateIndex) {
            this.stateIndex = stateIndex;
        }

        public boolean containsKey(Object key) {
            class_2769 prop;
            return key instanceof class_2769 && ZeroCollidingReferenceStateTable.this.hasProperty(prop = (class_2769)key);
        }

        public int size() {
            return ZeroCollidingReferenceStateTable.this.properties.size();
        }

        public ObjectSet<Reference2ObjectMap.Entry<class_2769<?>, Comparable<?>>> reference2ObjectEntrySet() {
            if (this.entrySet == null) {
                this.entrySet = new EntrySet();
            }
            return this.entrySet;
        }

        public Comparable<?> get(Object key) {
            Comparable<?> comparable;
            if (key instanceof class_2769) {
                class_2769 prop = (class_2769)key;
                comparable = (Comparable<?>)ZeroCollidingReferenceStateTable.this.get(this.stateIndex, prop);
            } else {
                comparable = null;
            }
            return comparable;
        }

        class EntrySet
        extends AbstractObjectSet<Reference2ObjectMap.Entry<class_2769<?>, Comparable<?>>> {
            EntrySet() {
            }

            public ObjectIterator<Reference2ObjectMap.Entry<class_2769<?>, Comparable<?>>> iterator() {
                final Iterator<class_2769<?>> propIterator = ZeroCollidingReferenceStateTable.this.properties.iterator();
                return new ObjectIterator<Reference2ObjectMap.Entry<class_2769<?>, Comparable<?>>>(){

                    public boolean hasNext() {
                        return propIterator.hasNext();
                    }

                    public Reference2ObjectMap.Entry<class_2769<?>, Comparable<?>> next() {
                        class_2769 prop = (class_2769)propIterator.next();
                        return new AbstractReference2ObjectMap.BasicEntry((Object)prop, ZeroCollidingReferenceStateTable.this.get(MapView.this.stateIndex, prop));
                    }
                };
            }

            public int size() {
                return ZeroCollidingReferenceStateTable.this.properties.size();
            }
        }
    }
}

