/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.level.poi;

import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.ChunkSystemPoiManager;
import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.ChunkSystemPoiSection;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.class_155;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_4153;
import net.minecraft.class_4157;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PoiChunk {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoiChunk.class);
    public final class_3218 world;
    public final int chunkX;
    public final int chunkZ;
    public final int minSection;
    public final int maxSection;
    private final class_4157[] sections;
    private boolean isDirty;
    private boolean loaded;

    public PoiChunk(class_3218 world, int chunkX, int chunkZ, int minSection, int maxSection) {
        this(world, chunkX, chunkZ, minSection, maxSection, new class_4157[maxSection - minSection + 1]);
    }

    public PoiChunk(class_3218 world, int chunkX, int chunkZ, int minSection, int maxSection, class_4157[] sections) {
        this.world = world;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.minSection = minSection;
        this.maxSection = maxSection;
        this.sections = sections;
        if (this.sections.length != maxSection - minSection + 1) {
            throw new IllegalStateException("Incorrect length used, expected " + (maxSection - minSection + 1) + ", got " + this.sections.length);
        }
    }

    public void load() {
        TickThread.ensureTickThread((class_1937)this.world, this.chunkX, this.chunkZ, "Loading in poi chunk off-main");
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        ((ChunkSystemPoiManager)this.world.method_14178().method_19493()).moonrise$loadInPoiChunk(this);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isEmpty() {
        for (class_4157 section : this.sections) {
            if (section == null || ((ChunkSystemPoiSection)section).moonrise$isEmpty()) continue;
            return false;
        }
        return true;
    }

    public class_4157 getOrCreateSection(int chunkY) {
        if (chunkY >= this.minSection && chunkY <= this.maxSection) {
            int idx = chunkY - this.minSection;
            class_4157 ret = this.sections[idx];
            if (ret != null) {
                return ret;
            }
            class_4153 poiManager = this.world.method_19494();
            long key = CoordinateUtils.getChunkSectionKey(this.chunkX, chunkY, this.chunkZ);
            this.sections[idx] = new class_4157(() -> poiManager.method_19288(key));
            return this.sections[idx];
        }
        throw new IllegalArgumentException("chunkY is out of bounds, chunkY: " + chunkY + " outside [" + this.minSection + "," + this.maxSection + "]");
    }

    public class_4157 getSection(int chunkY) {
        if (chunkY >= this.minSection && chunkY <= this.maxSection) {
            return this.sections[chunkY - this.minSection];
        }
        return null;
    }

    public Optional<class_4157> getSectionForVanilla(int chunkY) {
        if (chunkY >= this.minSection && chunkY <= this.maxSection) {
            class_4157 ret = this.sections[chunkY - this.minSection];
            return ret == null ? Optional.empty() : ((ChunkSystemPoiSection)ret).moonrise$asOptional();
        }
        return Optional.empty();
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public class_2487 save() {
        class_6903 registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)this.world.method_30349());
        class_2487 ret = new class_2487();
        class_2487 sections = new class_2487();
        ret.method_10566("Sections", (class_2520)sections);
        ret.method_10569("DataVersion", class_155.method_16673().comp_4026().comp_4038());
        class_3218 world = this.world;
        int chunkX = this.chunkX;
        int chunkZ = this.chunkZ;
        for (int sectionY = this.minSection; sectionY <= this.maxSection; ++sectionY) {
            int finalSectionY;
            DataResult serializedResult;
            class_2520 serialized;
            class_4157 section = this.sections[sectionY - this.minSection];
            if (section == null || ((ChunkSystemPoiSection)section).moonrise$isEmpty() || (serialized = (class_2520)(serializedResult = class_4157.class_9865.field_52453.encodeStart((DynamicOps)registryOps, (Object)section.method_61451())).resultOrPartial(arg_0 -> PoiChunk.lambda$save$1(world, chunkX, finalSectionY = sectionY, chunkZ, arg_0)).orElse(null)) == null) continue;
            sections.method_10566(Integer.toString(sectionY), serialized);
        }
        return sections.method_33133() ? null : ret;
    }

    public static PoiChunk empty(class_3218 world, int chunkX, int chunkZ) {
        PoiChunk ret = new PoiChunk(world, chunkX, chunkZ, WorldUtil.getMinSection((class_1937)world), WorldUtil.getMaxSection((class_1937)world));
        ret.loaded = true;
        return ret;
    }

    public static PoiChunk parse(class_3218 world, int chunkX, int chunkZ, class_2487 data) {
        PoiChunk ret = PoiChunk.empty(world, chunkX, chunkZ);
        class_6903 registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)world.method_30349());
        class_2487 sections = data.method_68568("Sections");
        if (sections.method_33133()) {
            return ret;
        }
        class_4153 poiManager = world.method_19494();
        boolean readAnything = false;
        for (int sectionY = ret.minSection; sectionY <= ret.maxSection; ++sectionY) {
            class_4157 deserialized;
            String key = Integer.toString(sectionY);
            if (!sections.method_10545(key)) continue;
            class_2487 section = sections.method_68568(key);
            DataResult deserializeResult = class_4157.class_9865.field_52453.parse((DynamicOps)registryOps, (Object)section);
            int finalSectionY = sectionY;
            class_4157.class_9865 packed = deserializeResult.resultOrPartial(description -> LOGGER.error("Failed to deserialize poi chunk for world: " + WorldUtil.getWorldName((class_1937)world) + ", chunk: (" + chunkX + "," + finalSectionY + "," + chunkZ + "); description: " + description)).orElse(null);
            long coordinateKey = CoordinateUtils.getChunkSectionKey(chunkX, sectionY, chunkZ);
            class_4157 class_41572 = deserialized = packed == null ? null : packed.method_61453(() -> poiManager.method_19288(coordinateKey));
            if (deserialized == null || ((ChunkSystemPoiSection)deserialized).moonrise$isEmpty()) continue;
            readAnything = true;
            ret.sections[sectionY - ret.minSection] = deserialized;
        }
        ret.loaded = !readAnything;
        return ret;
    }

    private static /* synthetic */ void lambda$save$1(class_3218 world, int chunkX, int finalSectionY, int chunkZ, String description) {
        LOGGER.error("Failed to serialize poi chunk for world: " + WorldUtil.getWorldName((class_1937)world) + ", chunk: (" + chunkX + "," + finalSectionY + "," + chunkZ + "); description: " + description);
    }
}

