/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.scheduling.task;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.executor.PrioritisedExecutor;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemLevelChunk;
import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.ChunkSystemPoiManager;
import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.PoiChunk;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.task.ChunkProgressionTask;
import java.lang.invoke.VarHandle;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2821;
import net.minecraft.class_2839;
import net.minecraft.class_3218;
import net.minecraft.class_9761;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChunkFullTask
extends ChunkProgressionTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkFullTask.class);
    private final NewChunkHolder chunkHolder;
    private final class_2791 fromChunk;
    private final PrioritisedExecutor.PrioritisedTask convertToFullTask;
    protected volatile boolean scheduled;
    protected static final VarHandle SCHEDULED_HANDLE = ConcurrentUtil.getVarHandle(ChunkFullTask.class, "scheduled", Boolean.TYPE);

    public ChunkFullTask(ChunkTaskScheduler scheduler, class_3218 world, int chunkX, int chunkZ, NewChunkHolder chunkHolder, class_2791 fromChunk, Priority priority) {
        super(scheduler, world, chunkX, chunkZ);
        this.chunkHolder = chunkHolder;
        this.fromChunk = fromChunk;
        this.convertToFullTask = scheduler.createChunkTask(chunkX, chunkZ, this, priority);
    }

    @Override
    public class_2806 getTargetStatus() {
        return class_2806.field_12803;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        class_2818 chunk;
        PlatformHooks platformHooks = PlatformHooks.get();
        try {
            PoiChunk poiChunk = this.chunkHolder.getPoiChunk();
            if (poiChunk == null) {
                LOGGER.error("Expected poi chunk to be loaded with chunk for task " + this.toString());
            } else {
                poiChunk.load();
                ((ChunkSystemPoiManager)this.world.method_19494()).moonrise$checkConsistency(this.fromChunk);
            }
            class_2791 class_27912 = this.fromChunk;
            if (class_27912 instanceof class_2821) {
                class_2821 wrappedFull = (class_2821)class_27912;
                chunk = wrappedFull.method_12240();
            } else {
                class_3218 world = this.world;
                class_2839 protoChunk = (class_2839)this.fromChunk;
                chunk = new class_2818(this.world, protoChunk, unused -> PlatformHooks.get().postLoadProtoChunk(world, protoChunk));
                this.chunkHolder.replaceProtoChunk(new class_2821(chunk, false));
            }
            ((ChunkSystemLevelChunk)chunk).moonrise$setChunkHolder(this.chunkHolder);
            NewChunkHolder chunkHolder = this.chunkHolder;
            chunk.method_12207(chunkHolder::getChunkStatus);
            try {
                platformHooks.setCurrentlyLoading((class_9761)this.chunkHolder.vanillaChunkHolder, chunk);
                chunk.method_12206();
                ((ChunkSystemServerLevel)this.world).moonrise$getChunkTaskScheduler().chunkHolderManager.getOrCreateEntityChunk(this.chunkX, this.chunkZ, false);
                chunk.method_12226(true);
                chunk.method_31713();
                chunk.method_39305(this.world);
                chunk.method_65066(this.world.method_14178().field_17254.field_51861.comp_3323());
                platformHooks.chunkFullStatusComplete(chunk, (class_2839)this.fromChunk);
            }
            finally {
                platformHooks.setCurrentlyLoading((class_9761)this.chunkHolder.vanillaChunkHolder, null);
            }
        }
        catch (Throwable throwable) {
            this.complete(null, throwable);
            return;
        }
        this.complete((class_2791)chunk, null);
    }

    @Override
    public boolean isScheduled() {
        return this.scheduled;
    }

    @Override
    public void schedule() {
        if (SCHEDULED_HANDLE.getAndSet(this, true)) {
            throw new IllegalStateException("Cannot double call schedule()");
        }
        this.convertToFullTask.queue();
    }

    @Override
    public void cancel() {
        if (this.convertToFullTask.cancel()) {
            this.complete(null, null);
        }
    }

    @Override
    public Priority getPriority() {
        return this.convertToFullTask.getPriority();
    }

    @Override
    public void lowerPriority(Priority priority) {
        if (!Priority.isValidPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority " + String.valueOf((Object)priority));
        }
        this.convertToFullTask.lowerPriority(priority);
    }

    @Override
    public void setPriority(Priority priority) {
        if (!Priority.isValidPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority " + String.valueOf((Object)priority));
        }
        this.convertToFullTask.setPriority(priority);
    }

    @Override
    public void raisePriority(Priority priority) {
        if (!Priority.isValidPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority " + String.valueOf((Object)priority));
        }
        this.convertToFullTask.raisePriority(priority);
    }
}

