/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.command;

import ca.spottedleaf.moonrise.common.time.TickData;
import ca.spottedleaf.moonrise.common.util.ConfigHolder;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.JsonUtil;
import ca.spottedleaf.moonrise.common.util.MoonriseConstants;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.command.CommandClientCommandSource;
import ca.spottedleaf.moonrise.patches.profiler.client.ProfilerMinecraft;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightLightingProvider;
import ca.spottedleaf.moonrise.patches.tick_loop.TickLoopMinecraftServer;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2821;
import net.minecraft.class_2839;
import net.minecraft.class_310;
import net.minecraft.class_3176;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public final class MoonriseCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ThreadLocal<DecimalFormat> ONE_DECIMAL_PLACES = ThreadLocal.withInitial(() -> new DecimalFormat("#,##0.0"));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"moonrise").requires(src -> src.method_9259(src.method_9211().method_3798()) || !(src.method_9211() instanceof class_3176))).then(class_2170.method_9247((String)"holderinfo").executes(MoonriseCommand::holderInfo))).then(class_2170.method_9247((String)"chunkinfo").executes(MoonriseCommand::chunkInfo))).then(class_2170.method_9247((String)"reload").executes(MoonriseCommand::reload))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"relight").executes(ctx -> MoonriseCommand.relight((CommandContext<class_2168>)ctx, 10))).then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)0, (int)MoonriseConstants.MAX_VIEW_DISTANCE)).executes(ctx -> MoonriseCommand.relight((CommandContext<class_2168>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius")))))).then(class_2170.method_9247((String)"debug").then(class_2170.method_9247((String)"chunks").executes(MoonriseCommand::debugChunks)))).then(class_2170.method_9247((String)"tps").executes(MoonriseCommand::tps)));
    }

    public static void registerClient(CommandDispatcher<CommandClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"moonrisec").then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"profiler").then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"start").executes(ctx -> MoonriseCommand.startClientProfiler((CommandContext<CommandClientCommandSource>)ctx, -1.0))).then(RequiredArgumentBuilder.argument((String)"record_threshold", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)10000.0)).executes(ctx -> MoonriseCommand.startClientProfiler((CommandContext<CommandClientCommandSource>)ctx, DoubleArgumentType.getDouble((CommandContext)ctx, (String)"record_threshold")))))).then(LiteralArgumentBuilder.literal((String)"stop").executes(MoonriseCommand::stopClientProfiler))));
    }

    private static int startClientProfiler(CommandContext<CommandClientCommandSource> ctx, double recordThreshold) {
        boolean started = ((ProfilerMinecraft)class_310.method_1551()).moonrise$profilerInstance().startSession(0L, recordThreshold < 0.0 ? -1L : Math.round(recordThreshold * 1000000.0));
        if (!started) {
            ((CommandClientCommandSource)ctx.getSource()).moonrise$sendFailure((class_2561)class_2561.method_43470((String)"Profiler is already running").method_27692(class_124.field_1061));
            return 0;
        }
        ((CommandClientCommandSource)ctx.getSource()).moonrise$sendSuccess((class_2561)class_2561.method_43470((String)"Started client profiler").method_27692(class_124.field_1078));
        return 1;
    }

    private static int stopClientProfiler(CommandContext<CommandClientCommandSource> ctx) {
        boolean ended = ((ProfilerMinecraft)class_310.method_1551()).moonrise$profilerInstance().endSession();
        if (!ended) {
            ((CommandClientCommandSource)ctx.getSource()).moonrise$sendFailure((class_2561)class_2561.method_43470((String)"Profiler is not running").method_27692(class_124.field_1061));
            return 0;
        }
        ((CommandClientCommandSource)ctx.getSource()).moonrise$sendSuccess((class_2561)class_2561.method_43470((String)"Stopped client profiler").method_27692(class_124.field_1078));
        return 1;
    }

    public static int holderInfo(CommandContext<class_2168> ctx) {
        int total = 0;
        int canUnload = 0;
        int nullChunks = 0;
        int readOnly = 0;
        int protoChunk = 0;
        int fullChunk = 0;
        for (NewChunkHolder holder : ((ChunkSystemServerLevel)((class_2168)ctx.getSource()).method_9225()).moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolders()) {
            NewChunkHolder.ChunkCompletion completion = holder.getLastChunkCompletion();
            class_2791 chunk = completion == null ? null : completion.chunk();
            ++total;
            if (chunk == null) {
                ++nullChunks;
            } else if (chunk instanceof class_2821) {
                ++readOnly;
            } else if (chunk instanceof class_2839) {
                ++protoChunk;
            } else if (chunk instanceof class_2818) {
                ++fullChunk;
            }
            if (holder.isSafeToUnload() != null) continue;
            ++canUnload;
        }
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Total: ").method_27692(class_124.field_1078).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(total)).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" Unloadable: ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(canUnload)).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" Null: ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(nullChunks)).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" ReadOnly: ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(readOnly)).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" Proto: ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(protoChunk)).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" Full: ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(fullChunk)).method_27692(class_124.field_1062)));
        return total;
    }

    public static int chunkInfo(CommandContext<class_2168> ctx) {
        int total = 0;
        int inactive = 0;
        int full = 0;
        int blockTicking = 0;
        int entityTicking = 0;
        for (NewChunkHolder holder : ((ChunkSystemServerLevel)((class_2168)ctx.getSource()).method_9225()).moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolders()) {
            NewChunkHolder.ChunkCompletion completion = holder.getLastChunkCompletion();
            class_2791 chunk = completion == null ? null : completion.chunk();
            if (!(chunk instanceof class_2818)) continue;
            class_2818 fullChunk = (class_2818)chunk;
            ++total;
            switch (holder.getChunkStatus()) {
                case field_19334: {
                    ++inactive;
                    break;
                }
                case field_44855: {
                    ++full;
                    break;
                }
                case field_44856: {
                    ++blockTicking;
                    break;
                }
                case field_13877: {
                    ++entityTicking;
                }
            }
        }
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Total: ").method_27692(class_124.field_1078).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(total)).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" Inactive: ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(inactive)).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" Full: ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(full)).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" Block Ticking: ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(blockTicking)).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" Entity Ticking: ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(entityTicking)).method_27692(class_124.field_1062)));
        return total;
    }

    public static int reload(CommandContext<class_2168> ctx) {
        if (ConfigHolder.reloadConfig()) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Reloaded Moonrise config.").method_27692(class_124.field_1078), true);
            return 1;
        }
        ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Failed to reload Moonrise config, see logs.").method_27692(class_124.field_1061));
        return 0;
    }

    public static int relight(CommandContext<class_2168> ctx, int radius) {
        class_243 center = ((class_2168)ctx.getSource()).method_9222();
        int centerChunkX = class_3532.method_15357((double)center.field_1352) >> 4;
        int centerChunkZ = class_3532.method_15357((double)center.field_1350) >> 4;
        ArrayList<class_1923> chunks = new ArrayList<class_1923>();
        LongOpenHashSet seen = new LongOpenHashSet();
        LongArrayFIFOQueue queue = new LongArrayFIFOQueue();
        long zero = CoordinateUtils.getChunkKey(0, 0);
        seen.add(zero);
        queue.enqueue(zero);
        chunks.add(new class_1923(centerChunkX, centerChunkZ));
        int[][] offsets = new int[][]{{-1, 0}, {1, 0}, {0, -1}, {0, 1}};
        while (!queue.isEmpty()) {
            long chunk = queue.dequeueLong();
            int chunkX = CoordinateUtils.getChunkX(chunk);
            int chunkZ = CoordinateUtils.getChunkZ(chunk);
            for (int[] offset : offsets) {
                int neighbourX = chunkX + offset[0];
                int neighbourZ = chunkZ + offset[1];
                long neighbour = CoordinateUtils.getChunkKey(neighbourX, neighbourZ);
                int dist = Math.max(Math.abs(neighbourX), Math.abs(neighbourZ));
                if (dist > radius || !seen.add(neighbour)) continue;
                queue.enqueue(neighbour);
                chunks.add(new class_1923(neighbourX + centerChunkX, neighbourZ + centerChunkZ));
            }
        }
        int ret = ((StarLightLightingProvider)((class_2168)ctx.getSource()).method_9225().method_22336()).starlight$serverRelightChunks(chunks, null, null);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Relighting ").method_27692(class_124.field_1078).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(ret)).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" chunks").method_27692(class_124.field_1078)), true);
        return ret;
    }

    public static int debugChunks(CommandContext<class_2168> ctx) {
        File file = ChunkTaskScheduler.getChunkDebugFile();
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Writing chunk information dump to '").method_27692(class_124.field_1078).method_10852((class_2561)class_2561.method_43470((String)file.toString()).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"'").method_27692(class_124.field_1078)), true);
        try {
            JsonUtil.writeJson((JsonElement)ChunkTaskScheduler.debugAllWorlds(((class_2168)ctx.getSource()).method_9211()), file);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Wrote chunk information dump to '").method_27692(class_124.field_1078).method_10852((class_2561)class_2561.method_43470((String)file.toString()).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"'").method_27692(class_124.field_1078)), true);
            return 1;
        }
        catch (Throwable throwable) {
            LOGGER.error("Failed to dump chunk information to file '" + file.getAbsolutePath() + "'", throwable);
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Failed to dump chunk information, see console").method_27692(class_124.field_1061));
            return 0;
        }
    }

    private static int colorFromHSV(double h, double s, double v) {
        double b;
        double g;
        double r;
        double c = v * s;
        double hh = h / 60.0;
        double x = c * (1.0 - Math.abs(hh % 2.0 - 1.0));
        double m = v - c;
        double cm = c + m;
        double xm = x + m;
        if (hh >= 0.0 && hh < 1.0) {
            r = cm;
            g = xm;
            b = m;
        } else if (hh >= 1.0 && hh < 2.0) {
            r = xm;
            g = cm;
            b = m;
        } else if (hh >= 2.0 && hh < 3.0) {
            r = m;
            g = cm;
            b = xm;
        } else if (hh >= 3.0 && hh < 4.0) {
            r = m;
            g = xm;
            b = cm;
        } else if (hh >= 4.0 && hh < 5.0) {
            r = xm;
            g = m;
            b = cm;
        } else if (hh >= 5.0 && hh < 6.0) {
            r = cm;
            g = m;
            b = xm;
        } else {
            g = b = m;
            r = b;
        }
        return Math.toIntExact(Math.round(r * 255.0)) << 16 | Math.toIntExact(Math.round(g * 255.0)) << 8 | Math.toIntExact(Math.round(b * 255.0));
    }

    private static int getColourForTPS(double tps) {
        double difference = Math.min(Math.abs(20.0 - tps), 20.0);
        double coordinate = difference <= 2.0 ? 70.0 + -35.0 * (difference - 2.0) : (difference <= 5.0 ? 30.0 + -13.333333333333334 * (difference - 5.0) : (difference <= 10.0 ? 10.0 + -4.0 * (difference - 10.0) : 0.0 + -1.0 * (difference - 20.0)));
        return MoonriseCommand.colorFromHSV(coordinate, 0.85, 0.8);
    }

    private static int getTPSColour(double tps, double expectedTps) {
        return MoonriseCommand.getColourForTPS(tps * (20.0 / expectedTps));
    }

    private static int getColourForMSPT(double mspt) {
        double clamped = Math.min(Math.abs(mspt), 50.0);
        double coordinate = clamped <= 15.0 ? 130.0 + -0.6666666666666666 * (clamped - 15.0) : (clamped <= 25.0 ? 90.0 + -4.0 * (clamped - 25.0) : (clamped <= 35.0 ? 30.0 + -6.0 * (clamped - 35.0) : (clamped <= 40.0 ? 15.0 + -3.0 * (clamped - 40.0) : 0.0 + -1.5 * (clamped - 50.0))));
        return MoonriseCommand.colorFromHSV(coordinate, 0.85, 0.8);
    }

    private static int getMSPTColour(double mspt, double expectedMaxMSPT) {
        return MoonriseCommand.getColourForMSPT(mspt * (50.0 / expectedMaxMSPT));
    }

    private static class_5250 formatMSPTReport(TickData.TickReportData report, long tickIntervalNS) {
        TickData.SegmentedAverage timePerTickData = report.timePerTickData();
        TickData.SegmentData all = timePerTickData.segmentAll();
        TickData.SegmentData percentile = timePerTickData.segment5PercentWorst();
        double minMS = all.least() / 1000000.0;
        double medMS = all.median() / 1000000.0;
        double avgMS = all.average() / 1000000.0;
        double percent = percentile.least() / 1000000.0;
        double max = all.greatest() / 1000000.0;
        double expectedMSPT = (double)tickIntervalNS / 1000000.0;
        return class_2561.method_43470((String)"").method_27692(class_124.field_1078).method_10852((class_2561)class_2561.method_43470((String)ONE_DECIMAL_PLACES.get().format(minMS)).method_54663(MoonriseCommand.getMSPTColour(minMS, expectedMSPT))).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)ONE_DECIMAL_PLACES.get().format(medMS)).method_54663(MoonriseCommand.getMSPTColour(medMS, expectedMSPT))).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)ONE_DECIMAL_PLACES.get().format(avgMS)).method_54663(MoonriseCommand.getMSPTColour(avgMS, expectedMSPT))).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)ONE_DECIMAL_PLACES.get().format(percent)).method_54663(MoonriseCommand.getMSPTColour(percent, expectedMSPT))).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)ONE_DECIMAL_PLACES.get().format(max)).method_54663(MoonriseCommand.getMSPTColour(max, expectedMSPT)));
    }

    public static int tps(CommandContext<class_2168> ctx) {
        MinecraftServer server = ((class_2168)ctx.getSource()).method_9211();
        TickData tickTimes5s = ((TickLoopMinecraftServer)server).moonrise$getTickData5s();
        TickData tickTimes10s = ((TickLoopMinecraftServer)server).moonrise$getTickData10s();
        TickData tickTimes1m = ((TickLoopMinecraftServer)server).moonrise$getTickData1m();
        TickData tickTimes5m = ((TickLoopMinecraftServer)server).moonrise$getTickData5m();
        TickData tickTimes15m = ((TickLoopMinecraftServer)server).moonrise$getTickData15m();
        long now = class_156.method_648();
        long tickIntervalNS = server.method_54833().method_54750();
        TickData.TickReportData report5s = tickTimes5s.generateTickReport(null, now, tickIntervalNS);
        TickData.TickReportData report10s = tickTimes10s.generateTickReport(null, now, tickIntervalNS);
        TickData.TickReportData report1m = tickTimes1m.generateTickReport(null, now, tickIntervalNS);
        TickData.TickReportData report5m = tickTimes5m.generateTickReport(null, now, tickIntervalNS);
        TickData.TickReportData report15m = tickTimes15m.generateTickReport(null, now, tickIntervalNS);
        if (report5s == null || report10s == null || report1m == null || report5m == null || report15m == null) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"No tick data to report").method_27692(class_124.field_1061), false);
            return 0;
        }
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"TPS ").method_27692(class_124.field_1078).method_10852((class_2561)class_2561.method_43470((String)"5s").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"10s").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"1m").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"5m").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"15m").method_27692(class_124.field_1062)), false);
        ((class_2168)ctx.getSource()).method_9226(() -> {
            double tps5s = report5s.tpsData().segmentAll().average();
            double tps10s = report10s.tpsData().segmentAll().average();
            double tps1m = report1m.tpsData().segmentAll().average();
            double tps5m = report5m.tpsData().segmentAll().average();
            double tps15m = report15m.tpsData().segmentAll().average();
            double expectedTps = 1.0 / (double)tickIntervalNS * 1.0E9;
            return class_2561.method_43470((String)" ").method_27692(class_124.field_1078).method_10852((class_2561)class_2561.method_43470((String)ONE_DECIMAL_PLACES.get().format(tps5s)).method_54663(MoonriseCommand.getTPSColour(tps5s, expectedTps))).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)ONE_DECIMAL_PLACES.get().format(tps10s)).method_54663(MoonriseCommand.getTPSColour(tps10s, expectedTps))).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)ONE_DECIMAL_PLACES.get().format(tps1m)).method_54663(MoonriseCommand.getTPSColour(tps1m, expectedTps))).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)ONE_DECIMAL_PLACES.get().format(tps5m)).method_54663(MoonriseCommand.getTPSColour(tps5m, expectedTps))).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)ONE_DECIMAL_PLACES.get().format(tps15m)).method_54663(MoonriseCommand.getTPSColour(tps15m, expectedTps)));
        }, false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)""), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"MSPT ").method_27692(class_124.field_1078).method_10852((class_2561)class_2561.method_43470((String)"min").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"med").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"avg").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"95%ile").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"max").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" for ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"10s").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"; ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"1m").method_27692(class_124.field_1062)), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)" ").method_27692(class_124.field_1078).method_10852((class_2561)MoonriseCommand.formatMSPTReport(report10s, tickIntervalNS)).method_10852((class_2561)class_2561.method_43470((String)";  ").method_27692(class_124.field_1078)).method_10852((class_2561)MoonriseCommand.formatMSPTReport(report1m, tickIntervalNS)), false);
        return 0;
    }
}

