/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.poi_lookup;

import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.doubles.Double2ObjectMap;
import it.unimi.dsi.fastutil.doubles.Double2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3532;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4157;
import net.minecraft.class_4158;
import net.minecraft.class_6880;

public final class PoiAccess {
    public static final boolean LOAD_FOR_SEARCHING = true;

    protected static double clamp(double val, double min, double max) {
        return val < min ? min : (val > max ? max : val);
    }

    protected static double getSmallestDistanceSquared(double boxMinX, double boxMinY, double boxMinZ, double boxMaxX, double boxMaxY, double boxMaxZ, double circleX, double circleY, double circleZ) {
        if (circleX >= boxMinX && circleX <= boxMaxX && circleY >= boxMinY && circleY <= boxMaxY && circleZ >= boxMinZ && circleZ <= boxMaxZ) {
            return 0.0;
        }
        double boxWidthX = (boxMaxX - boxMinX) / 2.0;
        double boxWidthY = (boxMaxY - boxMinY) / 2.0;
        double boxWidthZ = (boxMaxZ - boxMinZ) / 2.0;
        double boxCenterX = (boxMinX + boxMaxX) / 2.0;
        double boxCenterY = (boxMinY + boxMaxY) / 2.0;
        double boxCenterZ = (boxMinZ + boxMaxZ) / 2.0;
        double centerDiffX = circleX - boxCenterX;
        double centerDiffY = circleY - boxCenterY;
        double centerDiffZ = circleZ - boxCenterZ;
        centerDiffX = circleX - (PoiAccess.clamp(centerDiffX, -boxWidthX, boxWidthX) + boxCenterX);
        centerDiffY = circleY - (PoiAccess.clamp(centerDiffY, -boxWidthY, boxWidthY) + boxCenterY);
        centerDiffZ = circleZ - (PoiAccess.clamp(centerDiffZ, -boxWidthZ, boxWidthZ) + boxCenterZ);
        return centerDiffX * centerDiffX + centerDiffY * centerDiffY + centerDiffZ * centerDiffZ;
    }

    protected static long getKey(int minSection, int maxSection, int section, int radius) {
        return ((long)maxSection & 0xFFFFL) << 48 | ((long)minSection & 0xFFFFL) << 32 | ((long)section & 0xFFFFL) << 16 | ((long)radius & 0xFFFFL) << 0;
    }

    public static class_2338 findClosestPoiDataPosition(class_4153 poiStorage, Predicate<class_6880<class_4158>> villagePlaceType, Predicate<class_2338> positionPredicate, class_2338 sourcePosition, int range, double maxDistanceSquared, class_4153.class_4155 occupancy, boolean load) {
        class_4156 ret = PoiAccess.findClosestPoiDataRecord(poiStorage, villagePlaceType, positionPredicate, sourcePosition, range, maxDistanceSquared, occupancy, load);
        return ret == null ? null : ret.method_19141();
    }

    public static Pair<class_6880<class_4158>, class_2338> findClosestPoiDataTypeAndPosition(class_4153 poiStorage, Predicate<class_6880<class_4158>> villagePlaceType, Predicate<class_2338> positionPredicate, class_2338 sourcePosition, int range, double maxDistanceSquared, class_4153.class_4155 occupancy, boolean load) {
        class_4156 ret = PoiAccess.findClosestPoiDataRecord(poiStorage, villagePlaceType, positionPredicate, sourcePosition, range, maxDistanceSquared, occupancy, load);
        return ret == null ? null : Pair.of((Object)ret.method_19142(), (Object)ret.method_19141());
    }

    public static void findClosestPoiDataPositions(class_4153 poiStorage, Predicate<class_6880<class_4158>> villagePlaceType, Predicate<class_2338> positionPredicate, class_2338 sourcePosition, int range, double maxDistanceSquared, class_4153.class_4155 occupancy, boolean load, Set<class_2338> ret) {
        HashSet positions = new HashSet();
        Predicate<class_2338> newPredicate = pos -> {
            if (positionPredicate != null && !positionPredicate.test((class_2338)pos)) {
                return false;
            }
            return positions.add(pos.method_10062());
        };
        ArrayList<class_4156> toConvert = new ArrayList<class_4156>();
        PoiAccess.findClosestPoiDataRecords(poiStorage, villagePlaceType, newPredicate, sourcePosition, range, maxDistanceSquared, occupancy, load, toConvert);
        for (class_4156 record : toConvert) {
            ret.add(record.method_19141());
        }
    }

    public static class_4156 findClosestPoiDataRecord(class_4153 poiStorage, Predicate<class_6880<class_4158>> villagePlaceType, Predicate<class_2338> positionPredicate, class_2338 sourcePosition, int range, double maxDistanceSquared, class_4153.class_4155 occupancy, boolean load) {
        ArrayList<class_4156> ret = new ArrayList<class_4156>();
        PoiAccess.findClosestPoiDataRecords(poiStorage, villagePlaceType, positionPredicate, sourcePosition, range, maxDistanceSquared, occupancy, load, ret);
        return ret.isEmpty() ? null : (class_4156)ret.get(0);
    }

    public static class_4156 findClosestPoiDataRecord(class_4153 poiStorage, Predicate<class_6880<class_4158>> villagePlaceType, BiPredicate<class_6880<class_4158>, class_2338> predicate, class_2338 sourcePosition, int range, double maxDistanceSquared, class_4153.class_4155 occupancy, boolean load) {
        ArrayList<class_4156> ret = new ArrayList<class_4156>();
        PoiAccess.findClosestPoiDataRecords(poiStorage, villagePlaceType, predicate, sourcePosition, range, maxDistanceSquared, occupancy, load, ret);
        return ret.isEmpty() ? null : (class_4156)ret.get(0);
    }

    public static void findClosestPoiDataRecords(class_4153 poiStorage, Predicate<class_6880<class_4158>> villagePlaceType, Predicate<class_2338> positionPredicate, class_2338 sourcePosition, int range, double maxDistanceSquared, class_4153.class_4155 occupancy, boolean load, List<class_4156> ret) {
        BiPredicate<class_6880<class_4158>, class_2338> predicate = positionPredicate != null ? (type, pos) -> positionPredicate.test((class_2338)pos) : null;
        PoiAccess.findClosestPoiDataRecords(poiStorage, villagePlaceType, predicate, sourcePosition, range, maxDistanceSquared, occupancy, load, ret);
    }

    public static void findClosestPoiDataRecords(class_4153 poiStorage, Predicate<class_6880<class_4158>> villagePlaceType, BiPredicate<class_6880<class_4158>, class_2338> predicate, class_2338 sourcePosition, int range, double maxDistanceSquared, class_4153.class_4155 occupancy, boolean load, List<class_4156> ret) {
        Predicate occupancyFilter = occupancy.method_19135();
        ArrayList<class_4156> closestRecords = new ArrayList<class_4156>();
        double closestDistanceSquared = maxDistanceSquared;
        int lowerX = class_3532.method_15375((float)(sourcePosition.method_10263() - range)) >> 4;
        int lowerY = WorldUtil.getMinSection(poiStorage.field_27240);
        int lowerZ = class_3532.method_15375((float)(sourcePosition.method_10260() - range)) >> 4;
        int upperX = class_3532.method_15375((float)(sourcePosition.method_10263() + range)) >> 4;
        int upperY = WorldUtil.getMaxSection(poiStorage.field_27240);
        int upperZ = class_3532.method_15375((float)(sourcePosition.method_10260() + range)) >> 4;
        int centerX = sourcePosition.method_10263() >> 4;
        int centerY = class_3532.method_15340((int)(sourcePosition.method_10264() >> 4), (int)lowerY, (int)upperY);
        int centerZ = sourcePosition.method_10260() >> 4;
        long centerKey = CoordinateUtils.getChunkSectionKey(centerX, centerY, centerZ);
        LongArrayFIFOQueue queue = new LongArrayFIFOQueue();
        LongOpenHashSet seen = new LongOpenHashSet();
        seen.add(centerKey);
        queue.enqueue(centerKey);
        while (!queue.isEmpty()) {
            double sectionDistanceSquared;
            long key = queue.dequeueLong();
            int sectionX = CoordinateUtils.getChunkSectionX(key);
            int sectionY = CoordinateUtils.getChunkSectionY(key);
            int sectionZ = CoordinateUtils.getChunkSectionZ(key);
            if (sectionX < lowerX || sectionX > upperX || sectionY < lowerY || sectionY > upperY || sectionZ < lowerZ || sectionZ > upperZ || (sectionDistanceSquared = PoiAccess.getSmallestDistanceSquared(sectionX << 4, sectionY << 4, sectionZ << 4, sectionX << 4 | 0xF, sectionY << 4 | 0xF, sectionZ << 4 | 0xF, sourcePosition.method_10263(), sourcePosition.method_10264(), sourcePosition.method_10260())) > closestDistanceSquared) continue;
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dy = -1; dy <= 1; ++dy) {
                        int neighbourZ;
                        int neighbourY;
                        int neighbourX;
                        long neighbourKey;
                        if ((dx & 1) + (dy & 1) + (dz & 1) != 1 || !seen.add(neighbourKey = CoordinateUtils.getChunkSectionKey(neighbourX = sectionX + dx, neighbourY = sectionY + dy, neighbourZ = sectionZ + dz))) continue;
                        queue.enqueue(neighbourKey);
                    }
                }
            }
            Optional poiSectionOptional = load ? poiStorage.method_19294(key) : poiStorage.method_19293(key);
            if (poiSectionOptional == null || !poiSectionOptional.isPresent()) continue;
            class_4157 poiSection = (class_4157)poiSectionOptional.get();
            Map sectionData = poiSection.field_18498;
            if (sectionData.isEmpty()) continue;
            for (Map.Entry entry : sectionData.entrySet()) {
                if (!villagePlaceType.test((class_6880<class_4158>)((class_6880)entry.getKey()))) continue;
                for (class_4156 poiData : (Set)entry.getValue()) {
                    double dataRange;
                    class_2338 poiPosition;
                    if (!occupancyFilter.test(poiData) || Math.abs((poiPosition = poiData.method_19141()).method_10263() - sourcePosition.method_10263()) > range || Math.abs(poiPosition.method_10260() - sourcePosition.method_10260()) > range || (dataRange = poiPosition.method_10262((class_2382)sourcePosition)) > closestDistanceSquared || predicate != null && !predicate.test((class_6880<class_4158>)poiData.method_19142(), poiPosition)) continue;
                    if (dataRange < closestDistanceSquared) {
                        closestRecords.clear();
                        closestDistanceSquared = dataRange;
                    }
                    closestRecords.add(poiData);
                }
            }
        }
        closestRecords.sort((record1, record2) -> {
            class_2338 pos1 = record1.method_19141();
            class_2338 pos2 = record2.method_19141();
            int cx1 = pos1.method_10263() >> 4;
            int cz1 = pos1.method_10260() >> 4;
            int cx2 = pos2.method_10263() >> 4;
            int cz2 = pos2.method_10260() >> 4;
            if (cz2 != cz1) {
                return Integer.compare(cz1, cz2);
            }
            if (cx2 != cx1) {
                return Integer.compare(cx1, cx2);
            }
            return Integer.compare(pos1.method_10264() >> 4, pos2.method_10264() >> 4);
        });
        ret.addAll(closestRecords);
    }

    public static class_2338 findNearestPoiPosition(class_4153 poiStorage, Predicate<class_6880<class_4158>> villagePlaceType, Predicate<class_2338> positionPredicate, class_2338 sourcePosition, int range, double maxDistanceSquared, class_4153.class_4155 occupancy, boolean load) {
        class_4156 ret = PoiAccess.findNearestPoiRecord(poiStorage, villagePlaceType, positionPredicate, sourcePosition, range, maxDistanceSquared, occupancy, load);
        return ret == null ? null : ret.method_19141();
    }

    public static void findNearestPoiPositions(class_4153 poiStorage, Predicate<class_6880<class_4158>> villagePlaceType, Predicate<class_2338> positionPredicate, class_2338 sourcePosition, int range, double maxDistanceSquared, class_4153.class_4155 occupancy, boolean load, int max, List<Pair<class_6880<class_4158>, class_2338>> ret) {
        HashSet positions = new HashSet();
        Predicate<class_2338> newPredicate = pos -> {
            if (positionPredicate != null && !positionPredicate.test((class_2338)pos)) {
                return false;
            }
            return positions.add(pos.method_10062());
        };
        ArrayList<class_4156> toConvert = new ArrayList<class_4156>();
        PoiAccess.findNearestPoiRecords(poiStorage, villagePlaceType, newPredicate, sourcePosition, range, maxDistanceSquared, occupancy, load, max, toConvert);
        for (class_4156 record : toConvert) {
            ret.add((Pair<class_6880<class_4158>, class_2338>)Pair.of((Object)record.method_19142(), (Object)record.method_19141()));
        }
    }

    public static class_4156 findNearestPoiRecord(class_4153 poiStorage, Predicate<class_6880<class_4158>> villagePlaceType, Predicate<class_2338> positionPredicate, class_2338 sourcePosition, int range, double maxDistanceSquared, class_4153.class_4155 occupancy, boolean load) {
        ArrayList<class_4156> ret = new ArrayList<class_4156>();
        PoiAccess.findNearestPoiRecords(poiStorage, villagePlaceType, positionPredicate, sourcePosition, range, maxDistanceSquared, occupancy, load, 1, ret);
        return ret.isEmpty() ? null : (class_4156)ret.get(0);
    }

    public static void findNearestPoiRecords(class_4153 poiStorage, Predicate<class_6880<class_4158>> villagePlaceType, Predicate<class_2338> positionPredicate, class_2338 sourcePosition, int range, double maxDistanceSquared, class_4153.class_4155 occupancy, boolean load, int max, List<class_4156> ret) {
        Predicate occupancyFilter = occupancy.method_19135();
        Double2ObjectRBTreeMap closestRecords = new Double2ObjectRBTreeMap();
        int totalRecords = 0;
        double furthestDistanceSquared = maxDistanceSquared;
        int lowerX = class_3532.method_15375((float)(sourcePosition.method_10263() - range)) >> 4;
        int lowerY = WorldUtil.getMinSection(poiStorage.field_27240);
        int lowerZ = class_3532.method_15375((float)(sourcePosition.method_10260() - range)) >> 4;
        int upperX = class_3532.method_15375((float)(sourcePosition.method_10263() + range)) >> 4;
        int upperY = WorldUtil.getMaxSection(poiStorage.field_27240);
        int upperZ = class_3532.method_15375((float)(sourcePosition.method_10260() + range)) >> 4;
        int centerX = sourcePosition.method_10263() >> 4;
        int centerY = class_3532.method_15340((int)(sourcePosition.method_10264() >> 4), (int)lowerY, (int)upperY);
        int centerZ = sourcePosition.method_10260() >> 4;
        long centerKey = CoordinateUtils.getChunkSectionKey(centerX, centerY, centerZ);
        LongArrayFIFOQueue queue = new LongArrayFIFOQueue();
        LongOpenHashSet seen = new LongOpenHashSet();
        seen.add(centerKey);
        queue.enqueue(centerKey);
        while (!queue.isEmpty()) {
            long key = queue.dequeueLong();
            int sectionX = CoordinateUtils.getChunkSectionX(key);
            int sectionY = CoordinateUtils.getChunkSectionY(key);
            int sectionZ = CoordinateUtils.getChunkSectionZ(key);
            if (sectionX < lowerX || sectionX > upperX || sectionY < lowerY || sectionY > upperY || sectionZ < lowerZ || sectionZ > upperZ) continue;
            double sectionDistanceSquared = PoiAccess.getSmallestDistanceSquared(sectionX << 4, sectionY << 4, sectionZ << 4, sectionX << 4 | 0xF, sectionY << 4 | 0xF, sectionZ << 4 | 0xF, sourcePosition.method_10263(), sourcePosition.method_10264(), sourcePosition.method_10260());
            if (sectionDistanceSquared > (totalRecords >= max ? furthestDistanceSquared : maxDistanceSquared)) continue;
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dy = -1; dy <= 1; ++dy) {
                        int neighbourZ;
                        int neighbourY;
                        int neighbourX;
                        long neighbourKey;
                        if ((dx & 1) + (dy & 1) + (dz & 1) != 1 || !seen.add(neighbourKey = CoordinateUtils.getChunkSectionKey(neighbourX = sectionX + dx, neighbourY = sectionY + dy, neighbourZ = sectionZ + dz))) continue;
                        queue.enqueue(neighbourKey);
                    }
                }
            }
            Optional poiSectionOptional = load ? poiStorage.method_19294(key) : poiStorage.method_19293(key);
            if (poiSectionOptional == null || !poiSectionOptional.isPresent()) continue;
            class_4157 poiSection = (class_4157)poiSectionOptional.get();
            Map sectionData = poiSection.field_18498;
            if (sectionData.isEmpty()) continue;
            for (Map.Entry entry : sectionData.entrySet()) {
                if (!villagePlaceType.test((class_6880<class_4158>)((class_6880)entry.getKey()))) continue;
                for (class_4156 poiData : (Set)entry.getValue()) {
                    double dataRange;
                    class_2338 poiPosition;
                    if (!occupancyFilter.test(poiData) || Math.abs((poiPosition = poiData.method_19141()).method_10263() - sourcePosition.method_10263()) > range || Math.abs(poiPosition.method_10260() - sourcePosition.method_10260()) > range || (dataRange = poiPosition.method_10262((class_2382)sourcePosition)) > maxDistanceSquared || dataRange > furthestDistanceSquared && totalRecords >= max || positionPredicate != null && !positionPredicate.test(poiPosition)) continue;
                    if (dataRange > furthestDistanceSquared) {
                        furthestDistanceSquared = dataRange;
                    }
                    ((List)closestRecords.computeIfAbsent(dataRange, unused -> new ArrayList())).add(poiData);
                    if (++totalRecords < max || closestRecords.size() < 2) continue;
                    int entriesInClosest = 0;
                    ObjectBidirectionalIterator iterator = closestRecords.double2ObjectEntrySet().iterator();
                    double nextFurthestDistanceSquared = 0.0;
                    int len = closestRecords.size() - 1;
                    for (int i = 0; i < len; ++i) {
                        Double2ObjectMap.Entry recordEntry = (Double2ObjectMap.Entry)iterator.next();
                        entriesInClosest += ((List)recordEntry.getValue()).size();
                        nextFurthestDistanceSquared = recordEntry.getDoubleKey();
                    }
                    if (entriesInClosest < max) continue;
                    Double2ObjectMap.Entry recordEntry = (Double2ObjectMap.Entry)iterator.next();
                    totalRecords -= ((List)recordEntry.getValue()).size();
                    iterator.remove();
                    furthestDistanceSquared = nextFurthestDistanceSquared;
                }
            }
        }
        ArrayList closestRecordsUnsorted = new ArrayList();
        for (List records : closestRecords.values()) {
            closestRecordsUnsorted.addAll(records);
        }
        closestRecordsUnsorted.sort((record1, record2) -> {
            class_2338 pos1 = record1.method_19141();
            class_2338 pos2 = record2.method_19141();
            int cx1 = pos1.method_10263() >> 4;
            int cz1 = pos1.method_10260() >> 4;
            int cx2 = pos2.method_10263() >> 4;
            int cz2 = pos2.method_10260() >> 4;
            if (cz2 != cz1) {
                return Integer.compare(cz1, cz2);
            }
            if (cx2 != cx1) {
                return Integer.compare(cx1, cx2);
            }
            return Integer.compare(pos1.method_10264() >> 4, pos2.method_10264() >> 4);
        });
        for (int i = closestRecordsUnsorted.size() - 1; i >= max; --i) {
            closestRecordsUnsorted.remove(i);
        }
        ret.addAll(closestRecordsUnsorted);
    }

    public static class_2338 findAnyPoiPosition(class_4153 poiStorage, Predicate<class_6880<class_4158>> villagePlaceType, Predicate<class_2338> positionPredicate, class_2338 sourcePosition, int range, class_4153.class_4155 occupancy, boolean load) {
        class_4156 ret = PoiAccess.findAnyPoiRecord(poiStorage, villagePlaceType, positionPredicate, sourcePosition, range, occupancy, load);
        return ret == null ? null : ret.method_19141();
    }

    public static void findAnyPoiPositions(class_4153 poiStorage, Predicate<class_6880<class_4158>> villagePlaceType, Predicate<class_2338> positionPredicate, class_2338 sourcePosition, int range, class_4153.class_4155 occupancy, boolean load, int max, List<Pair<class_6880<class_4158>, class_2338>> ret) {
        HashSet positions = new HashSet();
        Predicate<class_2338> newPredicate = pos -> {
            if (positionPredicate != null && !positionPredicate.test((class_2338)pos)) {
                return false;
            }
            return positions.add(pos.method_10062());
        };
        ArrayList<class_4156> toConvert = new ArrayList<class_4156>();
        PoiAccess.findAnyPoiRecords(poiStorage, villagePlaceType, newPredicate, sourcePosition, range, occupancy, load, max, toConvert);
        for (class_4156 record : toConvert) {
            ret.add((Pair<class_6880<class_4158>, class_2338>)Pair.of((Object)record.method_19142(), (Object)record.method_19141()));
        }
    }

    public static class_4156 findAnyPoiRecord(class_4153 poiStorage, Predicate<class_6880<class_4158>> villagePlaceType, Predicate<class_2338> positionPredicate, class_2338 sourcePosition, int range, class_4153.class_4155 occupancy, boolean load) {
        ArrayList<class_4156> ret = new ArrayList<class_4156>();
        PoiAccess.findAnyPoiRecords(poiStorage, villagePlaceType, positionPredicate, sourcePosition, range, occupancy, load, 1, ret);
        return ret.isEmpty() ? null : (class_4156)ret.get(0);
    }

    public static void findAnyPoiRecords(class_4153 poiStorage, Predicate<class_6880<class_4158>> villagePlaceType, Predicate<class_2338> positionPredicate, class_2338 sourcePosition, int range, class_4153.class_4155 occupancy, boolean load, int max, List<class_4156> ret) {
        Predicate occupancyFilter = occupancy.method_19135();
        double rangeSquared = range * range;
        int added = 0;
        int lowerX = class_3532.method_15375((float)(sourcePosition.method_10263() - range)) >> 4;
        int lowerY = Math.max(WorldUtil.getMinSection(poiStorage.field_27240), class_3532.method_15375((float)(sourcePosition.method_10264() - range)) >> 4);
        int lowerZ = class_3532.method_15375((float)(sourcePosition.method_10260() - range)) >> 4;
        int upperX = class_3532.method_15375((float)(sourcePosition.method_10263() + range)) >> 4;
        int upperY = Math.min(WorldUtil.getMaxSection(poiStorage.field_27240), class_3532.method_15375((float)(sourcePosition.method_10264() + range)) >> 4);
        int upperZ = class_3532.method_15375((float)(sourcePosition.method_10260() + range)) >> 4;
        for (int currZ = lowerZ; currZ <= upperZ; ++currZ) {
            for (int currX = lowerX; currX <= upperX; ++currX) {
                for (int currY = lowerY; currY <= upperY; ++currY) {
                    Map sectionData;
                    class_4157 poiSection;
                    Optional poiSectionOptional = load ? poiStorage.method_19294(CoordinateUtils.getChunkSectionKey(currX, currY, currZ)) : poiStorage.method_19293(CoordinateUtils.getChunkSectionKey(currX, currY, currZ));
                    class_4157 class_41572 = poiSection = poiSectionOptional == null ? null : (class_4157)poiSectionOptional.orElse(null);
                    if (poiSection == null || (sectionData = poiSection.field_18498).isEmpty()) continue;
                    for (Map.Entry entry : sectionData.entrySet()) {
                        if (!villagePlaceType.test((class_6880<class_4158>)((class_6880)entry.getKey()))) continue;
                        for (class_4156 poiData : (Set)entry.getValue()) {
                            class_2338 poiPosition;
                            if (!occupancyFilter.test(poiData) || Math.abs((poiPosition = poiData.method_19141()).method_10263() - sourcePosition.method_10263()) > range || Math.abs(poiPosition.method_10260() - sourcePosition.method_10260()) > range || poiPosition.method_10262((class_2382)sourcePosition) > rangeSquared || positionPredicate != null && !positionPredicate.test(poiPosition)) continue;
                            ret.add(poiData);
                            if (++added < max) continue;
                            return;
                        }
                    }
                }
            }
        }
    }

    private PoiAccess() {
        throw new RuntimeException();
    }
}

