/*
 * Decompiled with CFR 0.152.
 */
package com.ametrin.block_variants.bop.level.block;

import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;

public final class FleshSlabBlock
extends SlabBlock {
    private final Supplier<SlabBlock> stripResult;

    public FleshSlabBlock(Supplier<SlabBlock> stripResult, BlockBehaviour.Properties properties) {
        super(properties);
        this.stripResult = stripResult;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
        if (itemAbility != ItemAbilities.SHEARS_TRIM) {
            return super.getToolModifiedState(state, context, itemAbility, simulate);
        }
        context.getLevel().playSound(null, context.getClickedPos(), SoundEvents.PUMPKIN_CARVE, SoundSource.BLOCKS, 1.0f, 1.0f);
        FleshSlabBlock.popResourceFromFace((Level)context.getLevel(), (BlockPos)context.getClickedPos(), (Direction)context.getClickedFace(), (ItemStack)new ItemStack((ItemLike)Items.ROTTEN_FLESH));
        return this.stripResult.get().withPropertiesOf(state);
    }
}

