/*
 * Decompiled with CFR 0.152.
 */
package com.ametrin.block_variants.bop.registry;

import biomesoplenty.api.block.BOPBlocks;
import com.ametrin.block_variants.bop.level.block.FleshSlabBlock;
import com.ametrin.block_variants.bop.level.block.FleshStairBlock;
import com.ametrin.block_variants.bop.level.block.FleshWallBlock;
import com.ametrin.block_variants.bop.registry.BBItems;
import com.ametrin.block_variants.bop.registry.BBWoodBlocks;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class BBBlocks {
    public static final DeferredRegister.Blocks REGISTER = DeferredRegister.createBlocks((String)"block_variants_bop");
    private static final SoundType FLESH_SOUND_TYPE = new SoundType(1.0f, 0.5f, SoundEvents.CORAL_BLOCK_BREAK, SoundEvents.CORAL_BLOCK_STEP, SoundEvents.CORAL_BLOCK_PLACE, SoundEvents.CORAL_BLOCK_HIT, SoundEvents.CORAL_BLOCK_FALL);
    public static final DeferredBlock<FleshStairBlock> FLESH_STAIRS = BBBlocks.register("flesh_stairs", properties -> new FleshStairBlock((Supplier<StairBlock>)POROUS_FLESH_STAIRS, BOPBlocks.FLESH.defaultBlockState(), (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_RED).strength(0.4f).sound(FLESH_SOUND_TYPE));
    public static final DeferredBlock<FleshSlabBlock> FLESH_SLAB = BBBlocks.register("flesh_slab", properties -> new FleshSlabBlock((Supplier<SlabBlock>)POROUS_FLESH_SLAB, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_RED).strength(0.4f).sound(FLESH_SOUND_TYPE));
    public static final DeferredBlock<FleshWallBlock> FLESH_WALL = BBBlocks.register("flesh_wall", properties -> new FleshWallBlock((Supplier<WallBlock>)POROUS_FLESH_WALL, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_RED).strength(0.4f).sound(FLESH_SOUND_TYPE));
    public static final DeferredBlock<StairBlock> POROUS_FLESH_STAIRS = BBBlocks.register("porous_flesh_stairs", properties -> new StairBlock(BOPBlocks.POROUS_FLESH.defaultBlockState(), properties), BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_RED).strength(0.4f).sound(FLESH_SOUND_TYPE));
    public static final DeferredBlock<SlabBlock> POROUS_FLESH_SLAB = BBBlocks.register("porous_flesh_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_RED).strength(0.4f).sound(FLESH_SOUND_TYPE));
    public static final DeferredBlock<WallBlock> POROUS_FLESH_WALL = BBBlocks.register("porous_flesh_wall", WallBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_RED).strength(0.4f).sound(FLESH_SOUND_TYPE));
    public static final DeferredBlock<StairBlock> BRIMSTONE_STAIRS = BBBlocks.register("brimstone_stairs", properties -> new StairBlock(BOPBlocks.BRIMSTONE.defaultBlockState(), properties), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.COLOR_YELLOW).requiresCorrectToolForDrops().strength(0.5f));
    public static final DeferredBlock<SlabBlock> BRIMSTONE_SLAB = BBBlocks.register("brimstone_slab", SlabBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.COLOR_YELLOW).requiresCorrectToolForDrops().strength(0.5f));
    public static final DeferredBlock<WallBlock> BRIMSTONE_WALL = BBBlocks.register("brimstone_wall", WallBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.COLOR_YELLOW).requiresCorrectToolForDrops().strength(0.5f));
    public static final DeferredBlock<StairBlock> ROSE_QUARTZ_BLOCK_STAIRS = BBBlocks.register("rose_quartz_block_stairs", properties -> new StairBlock(BOPBlocks.ROSE_QUARTZ_BLOCK.defaultBlockState(), properties), BlockBehaviour.Properties.of().mapColor(MapColor.CRIMSON_STEM).strength(1.5f).sound(SoundType.AMETHYST).requiresCorrectToolForDrops().lightLevel(state -> 10));
    public static final DeferredBlock<SlabBlock> ROSE_QUARTZ_BLOCK_SLAB = BBBlocks.register("rose_quartz_block_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.CRIMSON_STEM).strength(1.5f).sound(SoundType.AMETHYST).requiresCorrectToolForDrops().lightLevel(state -> 10));
    public static final DeferredBlock<WallBlock> ROSE_QUARTZ_BLOCK_WALL = BBBlocks.register("rose_quartz_block_wall", WallBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.CRIMSON_STEM).strength(1.5f).sound(SoundType.AMETHYST).requiresCorrectToolForDrops().lightLevel(state -> 10));

    private static <T extends Block> DeferredBlock<T> register(String name, Function<BlockBehaviour.Properties, T> block, BlockBehaviour.Properties properties) {
        return BBBlocks.register(name, block, properties, new Item.Properties());
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Function<BlockBehaviour.Properties, T> block, BlockBehaviour.Properties properties, Item.Properties itemProperties) {
        DeferredBlock registryObject = REGISTER.registerBlock(name, block, properties);
        BBItems.REGISTER.registerItem(name, iproperties -> new BlockItem((Block)registryObject.get(), iproperties), itemProperties);
        return registryObject;
    }

    public static Stream<Block> getAllNonWoodBlocks() {
        return REGISTER.getEntries().stream().map(Supplier::get);
    }

    public static Stream<Block> getAllBlocks() {
        return Stream.concat(BBBlocks.getAllNonWoodBlocks(), BBWoodBlocks.getAllWoodBlocks());
    }
}

