/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel_patcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class FileUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyAndMerge(Path srcPath, Path dstPath) throws IOException {
        File src = srcPath.toFile();
        File dst = dstPath.toFile();
        if (src.isDirectory()) {
            if (!dst.isDirectory()) throw new IOException("Cannot copy directory to file");
            File[] children = src.listFiles();
            if (children == null) {
                return;
            }
            for (File child : children) {
                FileUtils.copy(child, new File(dst, child.getName()));
            }
            return;
        } else if (dst.isDirectory()) {
            FileUtils.copy(src, new File(dst, src.getName()));
            return;
        } else {
            FileUtils.copy(src, dst);
        }
    }

    private static void copy(File src, File dst) throws IOException {
        if (src.isDirectory()) {
            if (!dst.exists() && !dst.mkdirs()) {
                throw new IOException("Could not mkdir " + dst.getParent());
            }
            File[] children = src.listFiles();
            if (children == null) {
                return;
            }
            for (File child : children) {
                FileUtils.copy(child, new File(dst, child.getName()));
            }
        } else {
            if (!src.exists() && !src.createNewFile()) {
                throw new IOException("Could not touch " + src);
            }
            try (FileInputStream in = new FileInputStream(src);
                 FileOutputStream out = new FileOutputStream(dst);){
                ((InputStream)in).transferTo(out);
            }
        }
    }

    public static void moveRecursive(Path src, Path dst) throws IOException {
        if (Files.isDirectory(src, new LinkOption[0])) {
            if (!Files.exists(dst, new LinkOption[0])) {
                Files.createDirectory(dst, new FileAttribute[0]);
            }
            try (Stream<Path> stream = Files.list(src);){
                List<Path> children = stream.toList();
                for (Path child : children) {
                    FileUtils.moveRecursive(child, dst.resolve(child.getFileName()));
                }
            }
        } else {
            if (Files.exists(dst, new LinkOption[0])) {
                Files.delete(dst);
            }
            Files.move(src, dst, new CopyOption[0]);
        }
    }

    public static void deleteRecursive(File file) throws IOException {
        File[] children = file.listFiles();
        if (children != null) {
            for (File child : children) {
                FileUtils.deleteRecursive(child);
            }
        }
        if (!file.delete()) {
            throw new IOException("Could not delete " + file);
        }
    }

    public static Optional<File> findFolderInChildren(File folder, String name) {
        File[] files;
        if (folder.isDirectory() && (files = folder.listFiles()) != null) {
            for (File file : files) {
                Optional<File> res = FileUtils.findFolderIn(file, name);
                if (!res.isPresent()) continue;
                return res;
            }
        }
        return Optional.empty();
    }

    public static Optional<File> findFolderIn(File folder, String name) {
        if (folder.isDirectory()) {
            if (folder.getName().equals(name)) {
                return Optional.of(folder);
            }
            File[] files = folder.listFiles();
            if (files != null) {
                for (File file : files) {
                    Optional<File> res = FileUtils.findFolderIn(file, name);
                    if (!res.isPresent()) continue;
                    return res;
                }
            }
        }
        return Optional.empty();
    }
}

