/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel_patcher.forge;

import dev.djefrey.colorwheel_patcher.ClrwlPatcher;
import dev.djefrey.colorwheel_patcher.Version;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod(value="colorwheel_patcher")
public final class ClrwlPatcherForge {
    private final Pattern VERSION_REGEX = Pattern.compile("(\\d+).(\\d+).(\\d+).*");

    public ClrwlPatcherForge() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::onCommonSetup);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        String versionStr = ((ModContainer)ModList.get().getModContainerById("colorwheel_patcher").get()).getModInfo().getVersion().getQualifier();
        Matcher matcher = this.VERSION_REGEX.matcher(versionStr);
        if (!matcher.matches()) {
            throw new IllegalStateException("Could not parse Colorwheel mod version");
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        int incremental = Integer.parseInt(matcher.group(3));
        Path shaderPath = FMLPaths.GAMEDIR.get().resolve("shaderpacks");
        Path configPath = FMLPaths.CONFIGDIR.get().resolve("colorwheel_patcher");
        ClrwlPatcher.init(new Version(major, minor, incremental), shaderPath, configPath);
    }
}

