/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.emoji;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import fr.madu59.emoji.EmojiManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.neoforged.fml.loading.FMLPaths;

public class CustomEmojiManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("emojis-custom.json");
    public static Map<String, String> customEmojiMap = new LinkedHashMap<String, String>();

    public static boolean saveData(Map<String, String> map) {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson(map, (Appendable)writer);
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static Map<String, String> loadData() {
        Map map;
        block8: {
            BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);
            try {
                Type type = new TypeToken<Map<String, String>>(){}.getType();
                map = (Map)GSON.fromJson((Reader)reader, type);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return Collections.emptyMap();
                }
            }
            ((Reader)reader).close();
        }
        return map;
    }

    public static void load() {
        customEmojiMap = new LinkedHashMap<String, String>(CustomEmojiManager.loadData());
    }

    public static boolean addEmoji(String id, String value) {
        if (((String)id).contains(":")) {
            return false;
        }
        id = ":" + (String)id + ":";
        customEmojiMap.put((String)id, value);
        EmojiManager.addEmoji((String)id, value);
        return CustomEmojiManager.saveData(customEmojiMap);
    }

    public static boolean removeEmoji(String id) {
        if (((String)id).contains(":")) {
            return false;
        }
        if (!customEmojiMap.containsKey(id = ":" + (String)id + ":")) {
            return false;
        }
        customEmojiMap.remove(id);
        if (!EmojiManager.removeEmoji((String)id)) {
            return false;
        }
        return CustomEmojiManager.saveData(customEmojiMap);
    }
}

