/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.emoji;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fr.madu59.emoji.CustomEmojiManager;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;

public class EmojiCommand {
    public static void register(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"emojis").then(Commands.literal((String)"add").then(Commands.argument((String)"slug", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            boolean success = CustomEmojiManager.addEmoji(StringArgumentType.getString((CommandContext)context, (String)"slug"), StringArgumentType.getString((CommandContext)context, (String)"value"));
            if (success) {
                EmojiCommand.feedbackMessage((Component)Component.translatable((String)"emoji-added-success"));
            } else {
                EmojiCommand.feedbackMessage((Component)Component.translatable((String)"emoji-added-fail"));
            }
            return 1;
        })))));
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"emojis").then(Commands.literal((String)"remove").then(Commands.argument((String)"slug", (ArgumentType)StringArgumentType.word()).executes(context -> {
            boolean success = CustomEmojiManager.removeEmoji(StringArgumentType.getString((CommandContext)context, (String)"slug"));
            if (success) {
                EmojiCommand.feedbackMessage((Component)Component.translatable((String)"emoji-removed-success"));
            } else {
                EmojiCommand.feedbackMessage((Component)Component.translatable((String)"emoji-removed-fail"));
            }
            return 1;
        }))));
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"emojis").then(Commands.literal((String)"customlist").executes(context -> {
            if (CustomEmojiManager.customEmojiMap.size() > 0) {
                EmojiCommand.feedbackMessage((Component)Component.translatable((String)"display-custom-emoji-list"));
                for (Map.Entry<String, String> entry : CustomEmojiManager.customEmojiMap.entrySet()) {
                    EmojiCommand.feedbackMessage((Component)Component.literal((String)(entry.getKey() + " " + entry.getValue())));
                }
            } else {
                EmojiCommand.feedbackMessage((Component)Component.translatable((String)"empty-custom-emoji-list"));
            }
            return 1;
        })));
    }

    public static void feedbackMessage(Component message) {
        Minecraft.getInstance().player.displayClientMessage(message, false);
    }
}

