/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.emoji;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.madu59.EmojiMod;
import fr.madu59.emoji.CustomEmojiManager;
import fr.madu59.emoji.Emoji;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class EmojiManager {
    public static boolean loaded = false;
    private static final Map<String, String> EMOJIS = new HashMap<String, String>();
    public static final ArrayList<String> suggestions = new ArrayList();
    public static final ArrayList<Emoji> emojiList = new ArrayList();

    public static void load() {
        EmojiMod.LOGGER.info("Trying to load emojis");
        EMOJIS.clear();
        suggestions.clear();
        emojiList.clear();
        try (InputStream is = ((Resource)Minecraft.getInstance().getResourceManager().getResource(ResourceLocation.tryParse((String)"emojis:emojis.json")).get()).open();){
            EmojiMod.LOGGER.info("Emojis loaded");
            JsonObject obj = JsonParser.parseReader((Reader)new InputStreamReader(is)).getAsJsonObject();
            for (Map.Entry entry : obj.entrySet()) {
                EmojiManager.addEmoji((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
            for (Map.Entry entry : CustomEmojiManager.customEmojiMap.entrySet()) {
                EmojiManager.addEmoji((String)entry.getKey(), (String)entry.getValue());
            }
            loaded = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String get(String name) {
        return EMOJIS.get(name);
    }

    public static Set<String> getNames() {
        return EMOJIS.keySet();
    }

    public static void addEmoji(String id, String value) {
        EMOJIS.put(id, value);
        String suggestion = id + " " + value;
        suggestions.add(suggestion);
        emojiList.add(new Emoji(id, value, suggestion));
    }

    public static boolean removeEmoji(String id) {
        for (Emoji emoji : emojiList) {
            if (!emoji.getId().equals(id)) continue;
            EMOJIS.remove(id);
            suggestions.remove(emoji.getSuggestion());
            emojiList.remove(emoji);
            return true;
        }
        return false;
    }
}

