/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.mixin;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fr.madu59.emoji.EmojiManager;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.commands.SharedSuggestionProvider;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CommandSuggestions.class})
public abstract class CommandSuggestionsMixin {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+)");
    private static final Pattern COLLON_PATTERN = Pattern.compile("(:)");
    @Shadow
    @Final
    EditBox input;
    @Shadow
    @Final
    boolean commandsOnly;
    @Shadow
    @Nullable
    private CompletableFuture<Suggestions> pendingSuggestions;

    @Shadow
    public abstract void showSuggestions(boolean var1);

    @Inject(at={@At(value="TAIL")}, method={"updateCommandInfo"}, cancellable=true)
    private void updateCommandInfo(CallbackInfo ci) {
        boolean isCommand;
        String string = this.input.getValue();
        StringReader stringReader = new StringReader(string);
        boolean bl = isCommand = stringReader.canRead() && stringReader.peek() == '/';
        if (isCommand) {
            stringReader.skip();
        }
        if (!this.commandsOnly && !isCommand) {
            int cursorPos = this.input.getCursorPosition();
            String beforeCursorText = string.substring(0, cursorPos);
            int emojiStart = this.getLastPattern(beforeCursorText, COLLON_PATTERN);
            int lastSpace = this.getLastPattern(beforeCursorText, WHITESPACE_PATTERN);
            if (emojiStart >= 0 && emojiStart >= lastSpace && emojiStart <= cursorPos && beforeCursorText.charAt(emojiStart) == ':') {
                this.pendingSuggestions = SharedSuggestionProvider.suggest(EmojiManager.suggestions, (SuggestionsBuilder)new SuggestionsBuilder(beforeCursorText, emojiStart));
                this.pendingSuggestions.thenRun(() -> {
                    if (!this.pendingSuggestions.isDone()) {
                        return;
                    }
                    this.showSuggestions(false);
                });
                ci.cancel();
            }
        }
    }

    private int getLastPattern(String string, Pattern pattern) {
        if (string == null || string.isEmpty()) {
            return -1;
        }
        Matcher matcher = pattern.matcher(string);
        int lastIndex = -1;
        while (matcher.find()) {
            lastIndex = matcher.start();
        }
        return lastIndex;
    }
}

