/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.mixin;

import fr.madu59.emoji.Emoji;
import fr.madu59.emoji.EmojiManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.components.EditBox;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EditBox.class})
public abstract class EditBoxMixin {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+)");
    private static final Pattern COLLON_PATTERN = Pattern.compile("(:)");

    @Shadow
    public abstract String getValue();

    @Shadow
    public abstract int getCursorPosition();

    @Shadow
    public abstract void deleteChars(int var1);

    @Shadow
    public abstract void setHighlightPos(int var1);

    @Shadow
    public abstract void insertText(String var1);

    @Inject(method={"charTyped"}, at={@At(value="RETURN")})
    private void useSuggestion(char c, int i, CallbackInfoReturnable<Boolean> ci) {
        if (((Boolean)ci.getReturnValue()).booleanValue() && c == ':') {
            int lastSpace;
            Object value = this.getValue();
            int cursorPos = this.getCursorPosition();
            int emojiStart = this.getLastPattern((String)(value = ((String)value).substring(0, cursorPos - 1)), COLLON_PATTERN);
            if (emojiStart >= (lastSpace = this.getLastPattern((String)value, WHITESPACE_PATTERN)) && emojiStart >= 0) {
                value = ((String)value).substring(emojiStart) + c;
                for (Emoji emoji : EmojiManager.emojiList) {
                    if (!((String)value).equals(emoji.getId())) continue;
                    this.deleteChars(-emoji.getId().length());
                    this.setHighlightPos(this.getCursorPosition());
                    this.insertText(emoji.getEmoji());
                    return;
                }
            }
        }
    }

    private int getLastPattern(String string, Pattern pattern) {
        if (string == null || string.isEmpty()) {
            return -1;
        }
        Matcher matcher = pattern.matcher(string);
        int lastIndex = -1;
        while (matcher.find()) {
            lastIndex = matcher.start();
        }
        return lastIndex;
    }
}

