/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.mixin;

import com.mojang.brigadier.suggestion.Suggestion;
import fr.madu59.emoji.Emoji;
import fr.madu59.emoji.EmojiManager;
import fr.madu59.mixin.CommandSuggestionsAccessor;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.gui.components.EditBox;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CommandSuggestions.SuggestionsList.class})
public abstract class SuggestionsListMixin {
    @Shadow
    private int current;
    @Shadow
    @Final
    private List<Suggestion> suggestionList;

    @Inject(method={"useSuggestion"}, at={@At(value="TAIL")})
    private void useSuggestion(CallbackInfo ci) {
        CommandSuggestions outer;
        try {
            Field outerField = this.getClass().getDeclaredField("this$0");
            outerField.setAccessible(true);
            outer = (CommandSuggestions)outerField.get(this);
        }
        catch (ReflectiveOperationException e) {
            return;
        }
        EditBox editBox = ((CommandSuggestionsAccessor)outer).getInput();
        Suggestion suggestion = this.suggestionList.get(this.current);
        for (Emoji emoji : EmojiManager.emojiList) {
            if (!suggestion.getText().equals(emoji.getSuggestion())) continue;
            editBox.deleteChars(-(emoji.getId().length() + emoji.getEmoji().length() + 1));
            editBox.setHighlightPos(editBox.getCursorPosition());
            editBox.insertText(emoji.getEmoji());
            return;
        }
    }
}

