/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.mixin;

import fr.madu59.emoji.Emoji;
import fr.madu59.emoji.EmojiManager;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.font.TextFieldHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TextFieldHelper.class})
public abstract class TextFieldHelperMixin {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+)");
    private static final Pattern COLLON_PATTERN = Pattern.compile("(:)");
    @Shadow
    @Final
    Supplier<String> getMessageFn;
    @Shadow
    @Final
    private int cursorPos;

    @Shadow
    public abstract void removeCharsFromCursor(int var1);

    @Shadow
    public abstract void insertText(String var1);

    @Inject(method={"charTyped"}, at={@At(value="RETURN")})
    private void charTyped(char c, CallbackInfoReturnable<Boolean> ci) {
        int lastSpace;
        if (c != ':') {
            return;
        }
        Object value = this.getMessageFn.get();
        int cursorPos = this.cursorPos;
        int emojiStart = this.getLastPattern((String)(value = ((String)value).substring(0, cursorPos - 1)), COLLON_PATTERN);
        if (emojiStart >= (lastSpace = this.getLastPattern((String)value, WHITESPACE_PATTERN)) && emojiStart >= 0) {
            value = ((String)value).substring(emojiStart) + c;
            for (Emoji emoji : EmojiManager.emojiList) {
                if (!((String)value).equals(emoji.getId())) continue;
                this.removeCharsFromCursor(-emoji.getId().length());
                this.insertText(emoji.getEmoji());
                return;
            }
        }
    }

    private int getLastPattern(String string, Pattern pattern) {
        if (string == null || string.isEmpty()) {
            return -1;
        }
        Matcher matcher = pattern.matcher(string);
        int lastIndex = -1;
        while (matcher.find()) {
            lastIndex = matcher.start();
        }
        return lastIndex;
    }
}

