/*
 * Decompiled with CFR 0.152.
 */
package com.dinoproo.legendsawaken.jurassic.block.custom;

import com.dinoproo.legendsawaken.jurassic.block.entity.custom.FenceGateBlockEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class FenceGateBlock
extends class_2248
implements class_2343 {
    private static final class_265 LEFT_POST = class_2248.method_9541((double)-4.0, (double)0.0, (double)3.0, (double)6.0, (double)16.0, (double)13.0);
    private static final class_265 LEFT_POST_TOP = class_2248.method_9541((double)-4.0, (double)0.0, (double)3.0, (double)6.0, (double)17.0, (double)13.0);
    private static final class_265 COVER = class_2248.method_9541((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private static final class_265 COVER_TOP = class_2248.method_9541((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)14.0, (double)12.0);
    private static final class_265 GATE_COVER = class_2248.method_9541((double)0.0, (double)0.0, (double)4.0, (double)6.0, (double)16.0, (double)12.0);
    private static final class_265 GATE_COVER_TOP = class_2248.method_9541((double)0.0, (double)0.0, (double)4.0, (double)6.0, (double)14.0, (double)12.0);
    private static final class_265 GATE_OPEN = class_2248.method_9541((double)0.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final class_265 GATE_OPEN_TOP = class_2248.method_9541((double)0.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0);
    private static final class_265 GATE_CLOSED = class_2248.method_9541((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final class_265 GATE_CLOSED_TOP = class_2248.method_9541((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)12.0, (double)10.0);
    private static final class_265 RIGHT_POST = class_2248.method_9541((double)10.0, (double)0.0, (double)3.0, (double)20.0, (double)16.0, (double)13.0);
    private static final class_265 RIGHT_POST_TOP = class_2248.method_9541((double)10.0, (double)0.0, (double)3.0, (double)20.0, (double)17.0, (double)13.0);
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 OPEN = class_2741.field_12537;
    public static final class_2754<GatePart> PART = class_2754.method_11850((String)"part", GatePart.class);
    private static final Map<GatePart, class_2338> RELATIVE_POS = new HashMap<GatePart, class_2338>();

    public FenceGateBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false))).method_11657(PART, (Comparable)((Object)GatePart.X2_Y0)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, OPEN, PART});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        if (state.method_11654(PART) == GatePart.X2_Y0) {
            return new FenceGateBlockEntity(pos, state);
        }
        return null;
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        GatePart part = (GatePart)((Object)state.method_11654(PART));
        boolean open = (Boolean)state.method_11654((class_2769)OPEN);
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_265 baseShape = class_259.method_1073();
        if (part == GatePart.X0_Y0 || part == GatePart.X0_Y1) {
            baseShape = class_259.method_1084((class_265)LEFT_POST, (class_265)COVER);
        } else if (part == GatePart.X0_Y2) {
            baseShape = class_259.method_1084((class_265)LEFT_POST_TOP, (class_265)COVER_TOP);
        } else if (part == GatePart.X1_Y0 || part == GatePart.X1_Y1) {
            baseShape = COVER;
        } else if (part == GatePart.X1_Y2) {
            baseShape = COVER_TOP;
        } else if (open) {
            if (part == GatePart.X2_Y0 || part == GatePart.X2_Y1) {
                baseShape = class_259.method_1084((class_265)GATE_COVER, (class_265)GATE_OPEN);
            } else if (part == GatePart.X2_Y2) {
                baseShape = class_259.method_1084((class_265)GATE_COVER_TOP, (class_265)GATE_OPEN_TOP);
            } else if (part == GatePart.X4_Y0 || part == GatePart.X4_Y1) {
                baseShape = RIGHT_POST;
            } else if (part == GatePart.X4_Y2) {
                baseShape = RIGHT_POST_TOP;
            }
        } else if (part == GatePart.X2_Y0 || part == GatePart.X2_Y1) {
            baseShape = class_259.method_1084((class_265)GATE_COVER, (class_265)GATE_CLOSED);
        } else if (part == GatePart.X2_Y2) {
            baseShape = class_259.method_1084((class_265)GATE_COVER_TOP, (class_265)GATE_CLOSED_TOP);
        } else if (part == GatePart.X3_Y0 || part == GatePart.X3_Y1) {
            baseShape = GATE_CLOSED;
        } else if (part == GatePart.X3_Y2) {
            baseShape = GATE_CLOSED_TOP;
        } else if (part == GatePart.X4_Y0 || part == GatePart.X4_Y1) {
            baseShape = class_259.method_1084((class_265)RIGHT_POST, (class_265)GATE_CLOSED);
        } else if (part == GatePart.X4_Y2) {
            baseShape = class_259.method_1084((class_265)RIGHT_POST_TOP, (class_265)GATE_CLOSED_TOP);
        }
        return FenceGateBlock.rotateShape(baseShape, class_2350.field_11043, facing);
    }

    public static class_265 rotateShape(class_265 shape, class_2350 from, class_2350 to) {
        int times = (to.method_10161() - from.method_10161() + 4) % 4;
        class_265[] buffer = new class_265[]{shape, class_259.method_1073()};
        for (int i = 0; i < times; ++i) {
            buffer[0].method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = class_259.method_1084((class_265)buffer[1], (class_265)class_259.method_1081((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = class_259.method_1073();
        }
        return buffer[0];
    }

    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153())).method_11657(PART, (Comparable)((Object)GatePart.X2_Y0));
        if (!this.method_9558(state, (class_4538)ctx.method_8045(), ctx.method_8037())) {
            return null;
        }
        return state;
    }

    protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        for (Map.Entry<GatePart, class_2338> entry : RELATIVE_POS.entrySet()) {
            class_2338 target = pos.method_10081((class_2382)this.rotate(entry.getValue(), facing));
            class_2680 targetState = world.method_8320(target);
            if (targetState.method_26215()) continue;
            return false;
        }
        return true;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        if (!world.field_9236) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
            for (Map.Entry<GatePart, class_2338> entry : RELATIVE_POS.entrySet()) {
                GatePart part = entry.getKey();
                class_2338 offset = this.rotate(entry.getValue(), facing);
                class_2338 target = pos.method_10081((class_2382)offset);
                world.method_8501(target, (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing)).method_11657(PART, (Comparable)((Object)part)));
            }
        }
    }

    private class_2338 rotate(class_2338 offset, class_2350 facing) {
        int x = offset.method_10263();
        int y = offset.method_10264();
        int z = offset.method_10260();
        return switch (facing) {
            case class_2350.field_11043 -> new class_2338(x, y, z);
            case class_2350.field_11035 -> new class_2338(-x, y, -z);
            case class_2350.field_11039 -> new class_2338(z, y, -x);
            case class_2350.field_11034 -> new class_2338(-z, y, x);
            default -> offset;
        };
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.field_9236) {
            class_2338 centralPos = this.getCentralPos(world, pos, state);
            class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
            for (Map.Entry<GatePart, class_2338> entry : RELATIVE_POS.entrySet()) {
                class_2338 target = centralPos.method_10081((class_2382)this.rotate(entry.getValue(), facing));
                class_2680 targetState = world.method_8320(target);
                if (targetState.method_26204() != this) continue;
                world.method_8651(target, true, (class_1297)player);
            }
        }
        return super.method_9576(world, pos, state, player);
    }

    private class_2338 getCentralPos(class_1937 world, class_2338 brokenPos, class_2680 state) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        for (Map.Entry<GatePart, class_2338> entry : RELATIVE_POS.entrySet()) {
            class_2338 rotatedOffset = this.rotate(entry.getValue(), facing);
            class_2338 candidate = brokenPos.method_10059((class_2382)rotatedOffset);
            class_2680 candidateState = world.method_8320(candidate);
            if (candidateState.method_26204() != this || candidateState.method_11654(PART) != GatePart.X2_Y0) continue;
            return candidate;
        }
        return brokenPos;
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!world.field_9236) {
            boolean newOpen = (Boolean)state.method_11654((class_2769)OPEN) == false;
            class_2338 origin = this.findOrigin(pos, (GatePart)((Object)state.method_11654(PART)));
            for (int x = 0; x < 5; ++x) {
                for (int y = 0; y < 3; ++y) {
                    class_2338 target = origin.method_10069(x, y, 0);
                    class_2680 targetState = world.method_8320(target);
                    if (!(targetState.method_26204() instanceof FenceGateBlock)) continue;
                    world.method_8652(target, (class_2680)targetState.method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(newOpen)), 3);
                }
            }
        }
        return class_1269.field_5812;
    }

    private class_2338 findOrigin(class_2338 pos, GatePart part) {
        int index = part.ordinal();
        int x = index % 5;
        int y = index / 5;
        return pos.method_10069(-x, -y, 0);
    }

    static {
        RELATIVE_POS.put(GatePart.X0_Y0, new class_2338(-2, 0, 0));
        RELATIVE_POS.put(GatePart.X1_Y0, new class_2338(-1, 0, 0));
        RELATIVE_POS.put(GatePart.X2_Y0, class_2338.field_10980);
        RELATIVE_POS.put(GatePart.X3_Y0, new class_2338(1, 0, 0));
        RELATIVE_POS.put(GatePart.X4_Y0, new class_2338(2, 0, 0));
        RELATIVE_POS.put(GatePart.X0_Y1, new class_2338(-2, 1, 0));
        RELATIVE_POS.put(GatePart.X1_Y1, new class_2338(-1, 1, 0));
        RELATIVE_POS.put(GatePart.X2_Y1, new class_2338(0, 1, 0));
        RELATIVE_POS.put(GatePart.X3_Y1, new class_2338(1, 1, 0));
        RELATIVE_POS.put(GatePart.X4_Y1, new class_2338(2, 1, 0));
        RELATIVE_POS.put(GatePart.X0_Y2, new class_2338(-2, 2, 0));
        RELATIVE_POS.put(GatePart.X1_Y2, new class_2338(-1, 2, 0));
        RELATIVE_POS.put(GatePart.X2_Y2, new class_2338(0, 2, 0));
        RELATIVE_POS.put(GatePart.X3_Y2, new class_2338(1, 2, 0));
        RELATIVE_POS.put(GatePart.X4_Y2, new class_2338(2, 2, 0));
    }

    public static enum GatePart implements class_3542
    {
        X0_Y0("x0_y0"),
        X1_Y0("x1_y0"),
        X2_Y0("x2_y0"),
        X3_Y0("x3_y0"),
        X4_Y0("x4_y0"),
        X0_Y1("x0_y1"),
        X1_Y1("x1_y1"),
        X2_Y1("x2_y1"),
        X3_Y1("x3_y1"),
        X4_Y1("x4_y1"),
        X0_Y2("x0_y2"),
        X1_Y2("x1_y2"),
        X2_Y2("x2_y2"),
        X3_Y2("x3_y2"),
        X4_Y2("x4_y2");

        private final String name;

        private GatePart(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

