/*
 * Decompiled with CFR 0.152.
 */
package com.dinoproo.legendsawaken.jurassic.block.entity.custom;

import com.dinoproo.legendsawaken.component.ModDataComponents;
import com.dinoproo.legendsawaken.jurassic.block.entity.JurassicBlockEntities;
import com.dinoproo.legendsawaken.jurassic.item.custom.DNAItem;
import com.dinoproo.legendsawaken.jurassic.recipe.ExtractingRecipe;
import com.dinoproo.legendsawaken.jurassic.recipe.ExtractingRecipeInput;
import com.dinoproo.legendsawaken.jurassic.recipe.JurassicRecipes;
import com.dinoproo.legendsawaken.jurassic.screen.custom.DNAExtractorScreenHandler;
import com.dinoproo.legendsawaken.jurassic.util.JurassicSpecies;
import com.dinoproo.legendsawaken.util.ImplementedInventory;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class DNAExtractorBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory<class_2338>,
ImplementedInventory {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> DNAExtractorBlockEntity.this.progress;
                case 1 -> DNAExtractorBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    DNAExtractorBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    DNAExtractorBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 600;

    public DNAExtractorBlockEntity(class_2338 pos, class_2680 state) {
        super(JurassicBlockEntities.DNA_EXTRACTOR_BE, pos, state);
    }

    public class_2338 getScreenOpeningData(class_3222 player) {
        return this.field_11867;
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"recipe.legendsawaken.extracting");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new DNAExtractorScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        nbt.method_10569("growth_chamber.progress", this.progress);
        nbt.method_10569("growth_chamber.max_progress", this.maxProgress);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        this.progress = nbt.method_10550("growth_chamber.progress");
        this.maxProgress = nbt.method_10550("growth_chamber.max_progress");
        super.method_11014(nbt, registryLookup);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (this.hasRecipe()) {
            ++this.progress;
            DNAExtractorBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
            if (this.hasCraftingFinished()) {
                this.craftItem();
                this.progress = 0;
            }
        } else {
            this.progress = 0;
        }
    }

    private void craftItem() {
        this.getCurrentRecipe().ifPresent(recipe -> {
            class_1799 result = ((ExtractingRecipe)recipe.comp_1933()).craft(new ExtractingRecipeInput((class_1799)this.inventory.get(0), this.field_11863), (class_7225.class_7874)Objects.requireNonNull(this.method_10997()).method_30349());
            this.method_5434(0, 1);
            this.method_5447(1, result);
            int level = (Integer)result.method_57825(ModDataComponents.DNA_LEVEL, (Object)0);
            this.spawnCraftingParticles(level);
            this.playCraftingSound(level);
        });
    }

    private void spawnCraftingParticles(int dnaLevel) {
        int count;
        class_2400 particle;
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        if (dnaLevel >= 80) {
            particle = class_2398.field_11215;
            count = 20;
        } else if (dnaLevel >= 50) {
            particle = class_2398.field_11211;
            count = 10;
        } else {
            particle = class_2398.field_11251;
            count = 5;
        }
        ((class_3218)this.field_11863).method_14199((class_2394)particle, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.0, (double)this.field_11867.method_10260() + 0.5, count, 0.3, 0.3, 0.3, 0.01);
    }

    private void playCraftingSound(int dnaLevel) {
        float pitch;
        class_3414 sound;
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        float volume = 0.5f;
        if (dnaLevel >= 80) {
            sound = class_3417.field_14709;
            pitch = 1.5f;
        } else if (dnaLevel >= 50) {
            sound = class_3417.field_14627;
            pitch = 1.2f;
        } else {
            sound = class_3417.field_14833;
            pitch = 0.6f;
        }
        this.field_11863.method_8396(null, this.field_11867, sound, class_3419.field_15245, volume, pitch);
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private boolean hasRecipe() {
        Optional<class_8786<ExtractingRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        class_1799 result = this.createCraftResult((ExtractingRecipe)recipe.get().comp_1933());
        return this.canInsertAmountIntoOutputSlot(result.method_7947()) && this.canInsertItemIntoOutputSlot();
    }

    private Optional<class_8786<ExtractingRecipe>> getCurrentRecipe() {
        return Objects.requireNonNull(this.method_10997()).method_8433().method_8132(JurassicRecipes.EXTRACTING_TYPE, (class_9695)new ExtractingRecipeInput((class_1799)this.inventory.get(0), this.field_11863), this.method_10997());
    }

    private class_1799 createCraftResult(ExtractingRecipe recipe) {
        class_1799 result = recipe.output().method_7972();
        if (result.method_7909() instanceof DNAItem) {
            ArrayList<JurassicSpecies> speciesList = new ArrayList<JurassicSpecies>(JurassicSpecies.values());
            assert (this.field_11863 != null);
            JurassicSpecies randomSpecies = (JurassicSpecies)speciesList.get(this.field_11863.field_9229.method_43048(speciesList.size()));
            result.method_57379(ModDataComponents.SPECIES, (Object)randomSpecies.id().toString());
            result.method_57379(ModDataComponents.DNA_LEVEL, (Object)(this.field_11863.field_9229.method_43048(100) + 1));
        }
        return result;
    }

    private boolean canInsertItemIntoOutputSlot() {
        return this.method_5438(1).method_7960();
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        int maxCount = this.method_5438(1).method_7960() ? 64 : this.method_5438(1).method_7914();
        int currentCount = this.method_5438(1).method_7947();
        return maxCount >= currentCount + count;
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 side) {
        return slot == 0;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }
}

