/*
 * Decompiled with CFR 0.152.
 */
package com.dinoproo.legendsawaken.player;

import com.dinoproo.legendsawaken.component.ModComponents;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;

public class PlayerStatsComponent
implements AutoSyncedComponent {
    private int level = 1;
    private double xp = 0.0;
    private int availablePoints = 1;
    private int healthLevel = 0;
    private int oxygenLevel = 0;
    private int meleeLevel = 0;
    private int fortitudeLevel = 0;
    public static final int MAX_LEVEL = 100;

    public int getLevel() {
        return this.level;
    }

    public double getXp() {
        return this.xp;
    }

    public int getAvailablePoints() {
        return this.availablePoints;
    }

    public void sync(class_1657 player) {
        ModComponents.STATS.sync((Object)player);
    }

    public static PlayerStatsComponent get(class_1657 player) {
        return (PlayerStatsComponent)ModComponents.STATS.get((Object)player);
    }

    public void addXp(class_1657 player, double amount) {
        if (this.level >= 100) {
            this.xp = 0.0;
            ModComponents.STATS.sync((Object)player);
            return;
        }
        this.xp += amount;
        while (this.level < 100 && this.xp >= PlayerStatsComponent.getXpForLevel(this.level + 1)) {
            this.xp -= PlayerStatsComponent.getXpForLevel(this.level + 1);
            this.levelUp();
        }
        if (this.level >= 100) {
            this.level = 100;
            this.xp = 0.0;
        }
        this.applyModifiers(player);
        ModComponents.STATS.sync((Object)player);
    }

    public void setXp(class_1657 player, double newXp) {
        this.xp = Math.max(0.0, newXp);
        while (this.level < 100 && this.xp >= PlayerStatsComponent.getXpForLevel(this.level + 1)) {
            this.xp -= PlayerStatsComponent.getXpForLevel(this.level + 1);
            this.levelUp();
        }
        ModComponents.STATS.sync((Object)player);
    }

    public void addPoints(class_1657 player, int amount) {
        this.availablePoints += amount;
        ModComponents.STATS.sync((Object)player);
    }

    public void resetStats(class_1657 player) {
        this.level = 1;
        this.xp = 0.0;
        this.availablePoints = 1;
        this.healthLevel = 0;
        this.oxygenLevel = 0;
        this.meleeLevel = 0;
        this.fortitudeLevel = 0;
        this.applyModifiers(player);
        ModComponents.STATS.sync((Object)player);
    }

    private void levelUp() {
        ++this.level;
        ++this.availablePoints;
    }

    public boolean spendPoint() {
        if (this.availablePoints > 0) {
            --this.availablePoints;
            return true;
        }
        return false;
    }

    public int getHealthLevel() {
        return this.healthLevel;
    }

    public int getOxygenLevel() {
        return this.oxygenLevel;
    }

    public int getMeleeLevel() {
        return this.meleeLevel;
    }

    public int getFortitudeLevel() {
        return this.fortitudeLevel;
    }

    public boolean increaseAttributeLevel(class_1657 player, Attribute attr) {
        if (!this.spendPoint()) {
            return false;
        }
        switch (attr.ordinal()) {
            case 0: {
                ++this.healthLevel;
                break;
            }
            case 1: {
                ++this.oxygenLevel;
                break;
            }
            case 2: {
                ++this.meleeLevel;
                break;
            }
            case 3: {
                ++this.fortitudeLevel;
            }
        }
        this.applyModifiers(player);
        ModComponents.STATS.sync((Object)player);
        return true;
    }

    public static double getXpForLevel(int level) {
        double baseXp = 50.0;
        double growthRate = 1.15;
        return Math.floor(50.0 * Math.pow(1.15, level - 1));
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        this.level = tag.method_10550("Level");
        this.xp = tag.method_10574("XP");
        this.availablePoints = tag.method_10550("AvailablePoints");
        this.healthLevel = tag.method_10550("HealthLevel");
        this.oxygenLevel = tag.method_10550("OxygenLevel");
        this.meleeLevel = tag.method_10550("MeleeLevel");
        this.fortitudeLevel = tag.method_10550("FortitudeLevel");
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        tag.method_10569("Level", this.level);
        tag.method_10549("XP", this.xp);
        tag.method_10569("AvailablePoints", this.availablePoints);
        tag.method_10569("HealthLevel", this.healthLevel);
        tag.method_10569("OxygenLevel", this.oxygenLevel);
        tag.method_10569("MeleeLevel", this.meleeLevel);
        tag.method_10569("FortitudeLevel", this.fortitudeLevel);
    }

    public void applyModifiers(class_1657 player) {
        this.applyAttributeModifier(player, (class_6880<class_1320>)class_5134.field_23716, "health_bonus", 2.0 * (double)this.healthLevel);
        this.applyAttributeModifier(player, (class_6880<class_1320>)class_5134.field_51583, "oxygen_bonus", 30.0f * (float)this.oxygenLevel);
        this.applyAttributeModifier(player, (class_6880<class_1320>)class_5134.field_23721, "melee_bonus", 0.05 * (double)this.meleeLevel, class_1322.class_1323.field_6330);
        this.applyAttributeModifier(player, (class_6880<class_1320>)class_5134.field_23724, "fortitude_bonus", this.fortitudeLevel);
    }

    private void applyAttributeModifier(class_1657 player, class_6880<class_1320> attribute, String name, double amount) {
        this.applyAttributeModifier(player, attribute, name, amount, class_1322.class_1323.field_6328);
    }

    private void applyAttributeModifier(class_1657 player, class_6880<class_1320> attribute, String name, double amount, class_1322.class_1323 operation) {
        class_1324 attrInstance = player.method_6127().method_45329(attribute);
        if (attrInstance == null) {
            return;
        }
        class_2960 id = class_2960.method_60654((String)("legendsawaken" + name));
        class_1322 existing = attrInstance.method_6199(id);
        if (existing != null) {
            attrInstance.method_6200(id);
        }
        if (amount != 0.0) {
            class_1322 modifier = new class_1322(id, amount, operation);
            attrInstance.method_26837(modifier);
        }
    }

    public static enum Attribute {
        HEALTH,
        OXYGEN,
        MELEE_DAMAGE,
        FORTITUDE;

    }
}

