package com.diamondgoobird.trialspawnertimer.mixins;

import com.diamondgoobird.trialspawnertimer.TimerHandler;
import com.diamondgoobird.trialspawnertimer.TrialSpawnerTimer;
import net.minecraft.class_1937;
import net.minecraft.class_2189;
import net.minecraft.class_2338;
import net.minecraft.class_2602;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_8960;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_2626.class)
public abstract class BlockUpdateS2CPacketMixin {
    @Shadow public abstract class_2338 getPos();
    @Shadow public abstract class_2680 getState();

    @Inject(method = "apply(Lnet/minecraft/network/listener/ClientPlayPacketListener;)V", at = @At("HEAD"))
    public void onBlockUpdate(class_2602 clientPlayPacketListener, CallbackInfo ci) {
        // We use the client's world because the packet doesn't send us one,
        // and we would only get block updates for the world we're in
        class_1937 w = class_310.method_1551().field_1687;
        assert w != null;
        // Check if our Trial Spawner was just destroyed and turned into air
        if (getState().method_26204() instanceof class_2189) {
            // If we have a timer at the given position, delete it
            if (TimerHandler.hasTimer(w, getPos())) {
                TimerHandler.deleteTime(w, getPos());
            }
        }
        // If this event fires for a block that's not a TrialSpawner we return
        if (!(getState().method_26204() instanceof class_8960)) {
            return;
        }
        // Send the block update to see if we need to update our timer
        TrialSpawnerTimer.onSpawnerBlockUpdate(w, getPos(), getState());
    }
}
