package com.diamondgoobird.trialspawnertimer.mixins;

import com.diamondgoobird.trialspawnertimer.TrialSpawnerTimer;
import com.diamondgoobird.trialspawnertimer.config.ConfigScreen;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_757;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(class_757.class)
public class GameRendererMixin {
    /**
     * Uses convoluted logic to display our GUI by changing the current screen right before the game tries to render it
     * @param instance the instance of the MinecraftClient
     * @return if the user just ran /trialspawnertimer then a new ConfigScreen instance, otherwise just the current screen
     */
    @Redirect(method = "render", at = @At(value = "FIELD", target = "Lnet/minecraft/client/MinecraftClient;currentScreen:Lnet/minecraft/client/gui/screen/Screen;", opcode = Opcodes.GETFIELD, ordinal = 0))
    public class_437 redirectGetScreen(class_310 instance) {
        /*
         Uses convoluted logic to display our GUI when the user runs /trialspawnertimer

         I had to do it this way because if I did:

         MinecraftClient.getInstance().setScreen()

         inside of the command execution it would either crash or throw an exception because it isn't on the render thread
        */
        if (TrialSpawnerTimer.showGui) {
            instance.method_1507(new ConfigScreen(instance.field_1755));
            TrialSpawnerTimer.showGui = false;
        }
        return instance.field_1755;
    }
}
