package com.diamondgoobird.trialspawnertimer;

import org.joml.Matrix4f;

import java.awt.*;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_8961;
import net.minecraft.class_898;

/**
 * Handles the rendering for the Trial Spawner Timer
 * These methods are called from the mixins that hook into
 * Minecraft's code
 */
public class TimerRenderer {
    /**
     * Draws the cooldown timer above a given TrialSpawnerBlockEntity
     *
     * @param world1 the world the block exists in
     * @param be the trialspawnerblockentity
     * @param matrixStack the 3d transformations used to draw the text
     * @param vertexConsumerProvider handles the layer management of the rendering
     * @param entityRenderDispatcher accounts for the rotation of the camera looking at the text
     * @param light the light level this text is being rendered in
     * @return returns false if the timer isn't rendered, true otherwise
     */
    public static boolean drawTimer(class_1937 world1, class_8961 be, class_4587 matrixStack, class_4597 vertexConsumerProvider, class_898 entityRenderDispatcher, int light) {
        // If the player just quit the game then don't render
        if (class_310.method_1551().field_1724 == null) {
            return false;
        }
        assert world1 != null;
        // Gets the ending time of the cooldown
        Timer ti = TimerHandler.getTimer(world1, be.method_11016());
        if (ti == null) {
            // No timer, so return
            return false;
        }
        long end = ti.getTimerEnd();
        long current = world1.method_8510();
        // Calculates remaining duration
        long left = Math.max(end - current, 0);

        // Deletes if the full cooldown has elapsed
        if (left == 0) {
            TimerHandler.deleteTime(world1, be.method_11016());
            return false;
        }

        // Calculates and displays time left
        double minutes = left / 1200.0;
        double seconds = (minutes - Math.floor(minutes)) * 60;
        class_2561 t = class_2561.method_30163(String.format("%02d:%02d", (int) minutes, (int) seconds));

        int c = getColor((double) left / ti.getCooldown());

        // Adjusts light level based on config
        if (TrialSpawnerTimer.getConfig().isBrighterText()) {
            light = 15728880;
        }

        drawTextAboveBlock(t, c, matrixStack, entityRenderDispatcher, vertexConsumerProvider, light);
        return true;
    }

    /**
     * Gets the color that the text should be based on the progress of the
     * timer that is completed
     *
     * @param progress the progress (from 0-1) of the color
     * @return the color representation in integer form
     */
    private static int getColor(double progress) {
        if (TrialSpawnerTimer.getConfig().getChromaTimer()) {
            // blue to red rainbow cycle
            return Color.getHSBColor((float) (progress) / 2, 1.0f, 1.0f).getRGB();
        }
        return Color.MAGENTA.getRGB();
    }

    /**
     * Draws colored text, facing the player, above a block this is inserted to the render code of
     *
     * @param t text to draw
     * @param color color to draw the text
     * @param matrixStack the 3d transformations used to draw the text
     * @param entityRenderDispatcher accounts for the rotation of the camera looking at the text
     * @param vertexConsumerProvider handles the layer management of the rendering
     * @param light the light level this text is being rendered at
     */
    public static void drawTextAboveBlock(class_2561 t, int color, class_4587 matrixStack, class_898 entityRenderDispatcher, class_4597 vertexConsumerProvider, int light) {
        class_327 r = class_310.method_1551().field_1772;

        float width = r.method_27525(t);
        matrixStack.method_46416(0.5f, 1.25f, 0.5f);
        // Uses player rotation
        matrixStack.method_22907(entityRenderDispatcher.method_24197());

        class_4587.class_4665 entry = matrixStack.method_23760();
        Matrix4f matrix4f = entry.method_23761();
        // Makes the text face the player
        matrix4f.rotate((float) Math.PI, 0.0F, 1.0F, 0.0F);
        matrix4f.scale(-0.025F, -0.025F, -0.025F);

        // -width/2 to center the text
        r.method_27522(t, -width / 2, 0.0f, color, true, matrix4f, vertexConsumerProvider, getRenderType(), 0, light);
    }

    /**
     * Gets the render type based on whether the text was specified to be see-through in the config
     * @return TextLayerType instance to draw text with, either NORMAL or SEE_THROUGH
     */
    public static class_327.class_6415 getRenderType() {
        return TrialSpawnerTimer.getConfig().getSeeThroughWalls() ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993;
    }
}
