package com.diamondgoobird.trialspawnertimer.mixins;

import com.diamondgoobird.trialspawnertimer.TimerRenderer;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_8961;
import net.minecraft.class_898;
import net.minecraft.class_8984;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static com.diamondgoobird.trialspawnertimer.TrialSpawnerTimer.*;

@Mixin(class_8984.class)
public class TrialSpawnerBlockEntityRendererMixin {
    @Shadow @Final private class_898 entityRenderDispatcher;

    @Inject(method = "render(Lnet/minecraft/block/entity/TrialSpawnerBlockEntity;FLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;IILnet/minecraft/util/math/Vec3d;)V", at = @At("RETURN"))
    public void onRender(class_8961 trialSpawnerBlockEntity, float f, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, int j, class_243 vec3d, CallbackInfo ci) {
        // If there is no timer rendered, check for updates
        boolean rend = TimerRenderer.drawTimer(trialSpawnerBlockEntity.method_10997(), trialSpawnerBlockEntity, matrixStack, vertexConsumerProvider, entityRenderDispatcher, i);
        // If higher sensitivity is on and the text didn't render then check if we want to add a timer
        if (getConfig().isHighSensitivity() && !rend) {
            onSpawnerStateUpdate(trialSpawnerBlockEntity.method_10997(), trialSpawnerBlockEntity.method_11016(), trialSpawnerBlockEntity.method_55151());
        }
    }
}
