package com.diamondgoobird.trialspawnertimer;

import com.diamondgoobird.trialspawnertimer.config.Config;
import com.diamondgoobird.trialspawnertimer.config.TrialSpawnerTimerCommand;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_8963;
import net.minecraft.class_8967;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.List;

import static com.diamondgoobird.trialspawnertimer.TimerHandler.*;

/**
 * Represents the TrialSpawnerTimer mod and its primary logic
 */
public class TrialSpawnerTimer implements ClientModInitializer {
    public static String VERSION = "1.1.1";
    public static final Logger LOGGER = LoggerFactory.getLogger("trialspawnertimer");
    public static boolean showGui;
    private static Config CONFIG;

    /**
     * List of Trial Spawner states that the block can switch to without resetting our timer
     */
    public static final List<class_8967> ACCEPTABLE_STATES = List.of(
            class_8967.field_47386,  // Occurs when timer is computed
            class_8967.field_47387,              // Gives player reward
            class_8967.field_47388                      // The remaining 29:56 ish
    );

    @Override
    public void onInitializeClient() {
        try {
            if (FabricLoaderImpl.INSTANCE.isModLoaded("fabric-command-api-v2")) {
                TrialSpawnerTimerCommand.register();
            }
            CONFIG = new Config();
            LOGGER.info("Initialized Trial Spawner Timer Version {}", VERSION);
        } catch (IOException e) {
            LOGGER.error("Error loading Trial Spawner Timer: {}", e.getMessage());
        }
    }

    /**
     * Gets the mod config instance
     * @return instance of the mod config
     */
    public static Config getConfig() {
        return CONFIG;
    }

    /**
     * Handles Trial Spawner block updates, tests if timers should be created/deleted
     * @param world the world the trial spawner is in
     * @param pos the position of the trial spawner
     * @param state the blockstate of the trial spawner
     */
    public static void onSpawnerBlockUpdate(class_1937 world, class_2338 pos, class_2680 state) {
        class_8967 st = (class_8967) state.method_11656().get(class_2741.field_47408);
        onSpawnerStateUpdate(world, pos, st);
    }

    /**
     * Handles Trial Spawner State updates, tests if timers should be created/deleted
     * @param world the world the trial spawner is in
     * @param pos the position of the trial spawner
     * @param state the TrialSpawnerState of the trial spawner
     */
    public static void onSpawnerStateUpdate(class_1937 world, class_2338 pos, class_8967 state) {
        // Only insert the time at the state when the server calculates the time
        if (shouldCreate(state) && !hasTimer(world, pos)) {
            insertTime(world, pos, world.method_8510(), class_8963.class_11349.field_60375.comp_4233());
            return;
        }
        // Reset the timer state if it changed to something we don't allow
        if (shouldReset(state)) {
            deleteTime(world, pos);
        }
    }
}
